/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.presenter;

import dev.onvoid.webrtc.RTCPeerConnectionState;
import dev.onvoid.webrtc.demo.context.ViewContextFactory;
import dev.onvoid.webrtc.demo.event.ApplicationEvent;
import dev.onvoid.webrtc.demo.event.FullscreenEvent;
import dev.onvoid.webrtc.demo.event.LoggedInEvent;
import dev.onvoid.webrtc.demo.event.ShowViewEvent;
import dev.onvoid.webrtc.demo.model.Contact;
import dev.onvoid.webrtc.demo.presenter.CallPresenter;
import dev.onvoid.webrtc.demo.presenter.ContactsPresenter;
import dev.onvoid.webrtc.demo.presenter.Presenter;
import dev.onvoid.webrtc.demo.presenter.StartPresenter;
import dev.onvoid.webrtc.demo.service.PeerConnectionService;
import dev.onvoid.webrtc.demo.view.MainView;
import dev.onvoid.webrtc.demo.view.View;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;

public class MainPresenter
extends Presenter<MainView> {
    private static System.Logger LOGGER = System.getLogger(MainPresenter.class.getName());
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ViewContextFactory viewFactory;
    private final PeerConnectionService peerConnectionService;
    private final Stack<Class<? extends Presenter>> presenterStack;
    private Presenter currentPresenter;

    @Inject
    MainPresenter(MainView view, ViewContextFactory viewFactory, PeerConnectionService peerConnectionService) {
        super(view);
        this.viewFactory = viewFactory;
        this.peerConnectionService = peerConnectionService;
        this.presenterStack = new Stack();
    }

    @Override
    public void handleEvent(ApplicationEvent event) {
        if (event instanceof LoggedInEvent) {
            this.handleEvent((LoggedInEvent)event);
        } else if (event instanceof FullscreenEvent) {
            this.handleEvent((FullscreenEvent)event);
        } else if (event instanceof ShowViewEvent) {
            this.handleEvent((ShowViewEvent)event);
        }
        super.handleEvent(event);
    }

    @Override
    public void initialize() {
        this.peerConnectionService.setOnConnectionState(this::onConnectionState);
        ((MainView)this.view).setOnClose(this::onClose);
        this.showStart();
    }

    @Override
    public void destroy() {
        this.peerConnectionService.setOnConnectionState(null);
        this.peerConnectionService.logout().thenRun(this.peerConnectionService::dispose);
        this.executor.shutdown();
        super.destroy();
    }

    private void showStart() {
        this.show(StartPresenter.class);
    }

    private void showContacts() {
        this.show(ContactsPresenter.class);
    }

    private void showCall() {
        this.show(CallPresenter.class);
    }

    private void handleEvent(LoggedInEvent event) {
        this.showContacts();
    }

    private void handleEvent(FullscreenEvent event) {
        ((MainView)this.view).setFullscreen(event.getActivate());
    }

    private void handleEvent(ShowViewEvent event) {
        this.show(event.getPresenterClass());
    }

    private void onClose() {
        this.destroy();
        ((MainView)this.view).hide();
    }

    private void onConnectionState(Contact contact, RTCPeerConnectionState state) {
        switch (state) {
            case CLOSED: 
            case DISCONNECTED: 
            case FAILED: {
                this.showContacts();
                break;
            }
            case CONNECTED: {
                this.showCall();
            }
        }
    }

    private void hideCurrentPresenter() {
        this.removeChild(this.currentPresenter);
        try {
            this.currentPresenter.destroy();
        }
        catch (Throwable t) {
            LOGGER.log(System.Logger.Level.ERROR, "Destroy presenter failed", t);
        }
        this.presenterStack.push(this.currentPresenter.getClass());
        this.currentPresenter = null;
    }

    private void show(Class<? extends Presenter> cls) {
        this.executor.execute(() -> {
            if (Objects.nonNull(this.currentPresenter)) {
                if (this.currentPresenter.getClass().equals(cls)) {
                    return;
                }
                this.hideCurrentPresenter();
            }
            try {
                Object presenter = this.createPresenter(cls);
                this.addChild((Presenter<?>)presenter);
                this.currentPresenter = presenter;
                ((MainView)this.view).setView((View)((Presenter)presenter).getView());
            }
            catch (Throwable t) {
                LOGGER.log(System.Logger.Level.ERROR, "Show view-presenter failed", t);
            }
        });
    }

    private <T extends Presenter<?>> T createPresenter(Class<T> cls) {
        Presenter presenter = (Presenter)this.viewFactory.getInstance(cls);
        presenter.setParent(this);
        presenter.setOnClose(() -> this.show(this.presenterStack.pop()));
        presenter.initialize();
        return (T)presenter;
    }
}

