/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.presenter;

import dev.onvoid.webrtc.demo.context.ViewContextFactory;
import dev.onvoid.webrtc.demo.presenter.Presenter;
import dev.onvoid.webrtc.demo.service.PeerConnectionService;
import dev.onvoid.webrtc.demo.view.DesktopSourceView;
import dev.onvoid.webrtc.demo.view.DesktopSourcesView;
import dev.onvoid.webrtc.media.video.desktop.DesktopCapturer;
import dev.onvoid.webrtc.media.video.desktop.DesktopFrame;
import dev.onvoid.webrtc.media.video.desktop.DesktopSource;
import dev.onvoid.webrtc.media.video.desktop.DesktopSourceType;
import dev.onvoid.webrtc.media.video.desktop.ScreenCapturer;
import dev.onvoid.webrtc.media.video.desktop.WindowCapturer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class DesktopSourcesPresenter
extends Presenter<DesktopSourcesView> {
    private final ViewContextFactory viewFactory;
    private final PeerConnectionService peerConnectionService;
    private final Map<DesktopSource, DesktopSourceView> screenSourceMap;
    private final Map<DesktopSource, DesktopSourceView> windowSourceMap;
    private final ScheduledExecutorService executorService;
    private ScheduledFuture<?> scheduledFuture;
    private ScreenCapturer screenCapturer;
    private WindowCapturer windowCapturer;
    private DesktopSource capturingScreenSource;
    private DesktopSource capturingWindowSource;

    @Inject
    DesktopSourcesPresenter(DesktopSourcesView view, ViewContextFactory viewFactory, PeerConnectionService peerConnectionService) {
        super(view);
        this.viewFactory = viewFactory;
        this.peerConnectionService = peerConnectionService;
        this.screenSourceMap = new ConcurrentHashMap<DesktopSource, DesktopSourceView>();
        this.windowSourceMap = new ConcurrentHashMap<DesktopSource, DesktopSourceView>();
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public void initialize() {
        this.screenCapturer = new ScreenCapturer();
        this.windowCapturer = new WindowCapturer();
        this.screenCapturer.start(this::onScreenCapture);
        this.windowCapturer.start(this::onWindowCapture);
        ((DesktopSourcesView)this.view).setOnDesktopSourceView(this::onDesktopSourceView);
        this.scheduledFuture = this.executorService.scheduleAtFixedRate(this::update, 0L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void destroy() {
        this.scheduledFuture.cancel(true);
        this.executorService.shutdownNow();
        this.screenCapturer.dispose();
        this.windowCapturer.dispose();
        super.destroy();
    }

    private void onDesktopSourceView(DesktopSourceView view) {
        DesktopSource source = view.getDesktopSource();
    }

    private void onScreenCapture(DesktopCapturer.Result result, DesktopFrame frame) {
        this.setDesktopFrame(result, frame, this.capturingScreenSource, this.screenSourceMap);
    }

    private void onWindowCapture(DesktopCapturer.Result result, DesktopFrame frame) {
        this.setDesktopFrame(result, frame, this.capturingWindowSource, this.windowSourceMap);
    }

    private void setDesktopFrame(DesktopCapturer.Result result, DesktopFrame frame, DesktopSource source, Map<DesktopSource, DesktopSourceView> map) {
        if (result != DesktopCapturer.Result.SUCCESS) {
            return;
        }
        if (Objects.isNull(source)) {
            return;
        }
        DesktopSourceView view = map.get(source);
        if (Objects.isNull(view)) {
            return;
        }
        view.setDesktopFrame(frame);
    }

    private void update() {
        DesktopSource source;
        List screenSources = this.screenCapturer.getDesktopSources();
        List windowSources = this.windowCapturer.getDesktopSources();
        this.cleanSources(screenSources, this.screenSourceMap);
        this.cleanSources(windowSources, this.windowSourceMap);
        this.addSources(screenSources, this.screenSourceMap, DesktopSourceType.SCREEN);
        this.addSources(windowSources, this.windowSourceMap, DesktopSourceType.WINDOW);
        Iterator iterator = screenSources.iterator();
        while (iterator.hasNext()) {
            this.capturingScreenSource = source = (DesktopSource)iterator.next();
            this.screenCapturer.selectSource(source);
            this.screenCapturer.captureFrame();
        }
        iterator = windowSources.iterator();
        while (iterator.hasNext()) {
            this.capturingWindowSource = source = (DesktopSource)iterator.next();
            this.windowCapturer.selectSource(source);
            this.windowCapturer.captureFrame();
        }
    }

    private void cleanSources(List<DesktopSource> list, Map<DesktopSource, DesktopSourceView> map) {
        for (DesktopSource source : map.keySet()) {
            if (list.contains(source)) continue;
            DesktopSourceView sourceView = map.remove(source);
            ((DesktopSourcesView)this.view).removeDesktopSourceView(sourceView);
        }
    }

    private void addSources(List<DesktopSource> list, Map<DesktopSource, DesktopSourceView> map, DesktopSourceType type) {
        int screenId = 1;
        for (DesktopSource source : list) {
            DesktopSourceView sourceView;
            if (type == DesktopSourceType.SCREEN) {
                source = new DesktopSource("Screen #" + screenId++, source.id);
            }
            if (Objects.isNull(sourceView = map.get(source))) {
                sourceView = this.viewFactory.getInstance(DesktopSourceView.class);
                sourceView.setDesktopSource(source);
                sourceView.setDesktopSourceType(type);
                map.put(source, sourceView);
                ((DesktopSourcesView)this.view).addDesktopSourceView(sourceView);
                continue;
            }
            sourceView.setDesktopSource(source);
        }
    }
}

