/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.presenter;

import dev.onvoid.webrtc.demo.context.ViewContextFactory;
import dev.onvoid.webrtc.demo.event.ShowViewEvent;
import dev.onvoid.webrtc.demo.model.ChatHistory;
import dev.onvoid.webrtc.demo.model.Chats;
import dev.onvoid.webrtc.demo.model.Contact;
import dev.onvoid.webrtc.demo.model.message.ChatMessage;
import dev.onvoid.webrtc.demo.model.message.ChatTextMessage;
import dev.onvoid.webrtc.demo.presenter.Presenter;
import dev.onvoid.webrtc.demo.presenter.SettingsPresenter;
import dev.onvoid.webrtc.demo.service.PeerConnectionService;
import dev.onvoid.webrtc.demo.util.ListChangeListener;
import dev.onvoid.webrtc.demo.util.ObservableList;
import dev.onvoid.webrtc.demo.view.ChatMessageView;
import dev.onvoid.webrtc.demo.view.ChatTextMessageView;
import dev.onvoid.webrtc.demo.view.ContactsView;
import java.time.LocalTime;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;

public class ContactsPresenter
extends Presenter<ContactsView> {
    private static System.Logger LOGGER = System.getLogger(ContactsPresenter.class.getName());
    private final ViewContextFactory viewFactory;
    private final PeerConnectionService peerConnectionService;
    private final Chats chats;
    private final MessagesListener messagesListener;
    private Contact selectedContact;

    @Inject
    ContactsPresenter(ContactsView view, ViewContextFactory viewFactory, PeerConnectionService peerConnectionService) {
        super(view);
        this.viewFactory = viewFactory;
        this.peerConnectionService = peerConnectionService;
        this.chats = new Chats();
        this.messagesListener = new MessagesListener();
    }

    @Override
    public void initialize() {
        ((ContactsView)this.view).setOnSettings(this::onSettings);
        ((ContactsView)this.view).setOnShareDesktop(this::onShareDesktop);
        ((ContactsView)this.view).setOnAudioCall(this::initAudioCall);
        ((ContactsView)this.view).setOnVideoCall(this::initVideoCall);
        ((ContactsView)this.view).setOnSendMessage(this::onSendMessage);
        ((ContactsView)this.view).setOnContactSelection(this::setSelectedContact);
        this.peerConnectionService.setContactEventConsumer(this::onContactEvent);
        this.peerConnectionService.setOnMessage(this::onRemoteMessage);
        ((CompletableFuture)this.peerConnectionService.getContacts().thenAccept(((ContactsView)this.view)::setContacts)).exceptionally(this::getContactsError);
    }

    @Override
    public void destroy() {
        this.peerConnectionService.setContactEventConsumer(null);
        this.peerConnectionService.setOnMessage(null);
        super.destroy();
    }

    private void onSettings() {
        this.publishEvent(new ShowViewEvent(SettingsPresenter.class));
    }

    private void onShareDesktop() {
    }

    private void initAudioCall() {
        this.peerConnectionService.call(this.selectedContact, false);
    }

    private void initVideoCall() {
        this.peerConnectionService.call(this.selectedContact, true);
    }

    private void setSelectedContact(Contact contact) {
        ChatHistory chatHistory;
        if (Objects.nonNull(this.selectedContact)) {
            chatHistory = this.getChatHistory(this.selectedContact);
            chatHistory.getMessages().removeListener(this.messagesListener);
        }
        this.selectedContact = contact;
        this.selectedContact.setUnreadMessages(0);
        chatHistory = this.getChatHistory(contact);
        chatHistory.getMessages().addListener(this.messagesListener);
        ((ContactsView)this.view).setContact(contact);
        for (ChatMessage message : chatHistory.getMessages()) {
            ((ContactsView)this.view).addChatMessage(this.createChatMessageView(message));
        }
    }

    private void onContactEvent(Contact contact, boolean active) {
        if (active) {
            ((ContactsView)this.view).addContact(contact);
        } else {
            ((ContactsView)this.view).removeContact(contact);
        }
    }

    private void onSendMessage(String text) {
        ChatTextMessage textMessage = new ChatTextMessage(text);
        textMessage.setOrigin(ChatMessage.Origin.LOCAL);
        textMessage.setTime(LocalTime.now());
        ((CompletableFuture)this.peerConnectionService.sendMessage(textMessage, this.selectedContact).exceptionally(throwable -> {
            LOGGER.log(System.Logger.Level.ERROR, "Send message failed", (Throwable)throwable);
            return null;
        })).thenRun(() -> {
            ChatHistory history = this.getChatHistory(this.selectedContact);
            history.getMessages().add(textMessage);
        });
    }

    private void onRemoteMessage(Contact contact, ChatMessage message) {
        if (!contact.equals(this.selectedContact)) {
            contact.setUnreadMessages(contact.getUnreadMessages() + 1);
        }
        ChatHistory history = this.getChatHistory(contact);
        history.getMessages().add(message);
    }

    private Void getContactsError(Throwable throwable) {
        LOGGER.log(System.Logger.Level.ERROR, "Get contacts failed", throwable);
        return null;
    }

    private ChatHistory getChatHistory(Contact contact) {
        ChatHistory chatHistory = this.chats.getChatHistory(contact);
        if (Objects.isNull(chatHistory)) {
            chatHistory = new ChatHistory();
            this.chats.setChatHistory(contact, chatHistory);
        }
        return chatHistory;
    }

    private ChatMessageView createChatMessageView(ChatMessage message) {
        if (message instanceof ChatTextMessage) {
            ChatTextMessageView view = this.viewFactory.getInstance(ChatTextMessageView.class);
            view.setTextMessage((ChatTextMessage)message);
            return view;
        }
        return null;
    }

    private class MessagesListener
    implements ListChangeListener<ObservableList<ChatMessage>> {
        private MessagesListener() {
        }

        @Override
        public void listItemsInserted(ObservableList<ChatMessage> list, int startIndex, int itemCount) {
            for (int i = startIndex; i < startIndex + itemCount; ++i) {
                ChatMessage message = (ChatMessage)list.get(i);
                ((ContactsView)ContactsPresenter.this.view).addChatMessage(ContactsPresenter.this.createChatMessageView(message));
            }
        }
    }
}

