/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.presenter;

import dev.onvoid.webrtc.demo.context.ViewContextFactory;
import dev.onvoid.webrtc.demo.event.FullscreenEvent;
import dev.onvoid.webrtc.demo.event.ShowViewEvent;
import dev.onvoid.webrtc.demo.presenter.DesktopSourcesPresenter;
import dev.onvoid.webrtc.demo.presenter.Presenter;
import dev.onvoid.webrtc.demo.service.PeerConnectionService;
import dev.onvoid.webrtc.demo.view.CallView;
import javax.inject.Inject;

public class CallPresenter
extends Presenter<CallView> {
    private static System.Logger LOGGER = System.getLogger(CallPresenter.class.getName());
    private final ViewContextFactory viewFactory;
    private final PeerConnectionService peerConnectionService;

    @Inject
    CallPresenter(CallView view, ViewContextFactory viewFactory, PeerConnectionService peerConnectionService) {
        super(view);
        this.viewFactory = viewFactory;
        this.peerConnectionService = peerConnectionService;
    }

    @Override
    public void initialize() {
        ((CallView)this.view).showLocalVideo(this.peerConnectionService.hasLocalVideoStream());
        ((CallView)this.view).setOnDesktopActive(this::onOnDesktopActive);
        ((CallView)this.view).setOnFullscreenActive(this::onFullscreenActive);
        ((CallView)this.view).setOnStatsActive(this.peerConnectionService::enableStats);
        ((CallView)this.view).setOnDisconnect(this.peerConnectionService::hangup);
        ((CallView)this.view).setOnMicrophoneActive(this.peerConnectionService::setMicrophoneActive);
        ((CallView)this.view).setOnCameraActive(this.peerConnectionService::setCameraActive);
        this.peerConnectionService.setOnLocalVideoStream(((CallView)this.view)::showLocalVideo);
        this.peerConnectionService.setOnRemoteVideoStream(((CallView)this.view)::showRemoteVideo);
        this.peerConnectionService.setOnLocalFrame(((CallView)this.view)::setLocalFrame);
        this.peerConnectionService.setOnRemoteFrame(((CallView)this.view)::setRemoteFrame);
        this.peerConnectionService.setOnStatsReport(((CallView)this.view)::setStatsReport);
    }

    @Override
    public void destroy() {
        this.peerConnectionService.setOnLocalVideoStream(null);
        this.peerConnectionService.setOnRemoteVideoStream(null);
        this.peerConnectionService.setOnLocalFrame(null);
        this.peerConnectionService.setOnRemoteFrame(null);
        this.peerConnectionService.setOnStatsReport(null);
        this.peerConnectionService.hangup();
        super.destroy();
    }

    private void onOnDesktopActive(boolean active) {
        if (active) {
            this.publishEvent(new ShowViewEvent(DesktopSourcesPresenter.class));
        }
    }

    private void onFullscreenActive(boolean active) {
        this.publishEvent(new FullscreenEvent(active));
    }

    private <T extends Presenter<?>> T createPresenter(Class<T> cls) {
        Presenter presenter = (Presenter)this.viewFactory.getInstance(cls);
        presenter.setParent(this);
        presenter.initialize();
        return (T)presenter;
    }
}

