/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.presenter;

import dev.onvoid.webrtc.demo.config.AudioConfiguration;
import dev.onvoid.webrtc.demo.config.Configuration;
import dev.onvoid.webrtc.demo.presenter.Presenter;
import dev.onvoid.webrtc.demo.view.AudioSettingsView;
import dev.onvoid.webrtc.media.audio.AudioDevice;
import dev.onvoid.webrtc.media.audio.AudioDeviceModule;
import java.util.List;
import javax.inject.Inject;

public class AudioSettingsPresenter
extends Presenter<AudioSettingsView> {
    private final AudioConfiguration config;

    @Inject
    AudioSettingsPresenter(AudioSettingsView view, Configuration config) {
        super(view);
        this.config = config.getAudioConfiguration();
    }

    @Override
    public void initialize() {
        AudioDeviceModule audioModule = new AudioDeviceModule();
        List playoutDevices = audioModule.getPlayoutDevices();
        List recordingDevices = audioModule.getRecordingDevices();
        AudioDevice playoutDevice = this.getAudioDevice(playoutDevices, this.config.getPlayoutDevice());
        AudioDevice recordingDevice = this.getAudioDevice(recordingDevices, this.config.getRecordingDevice());
        this.config.setPlayoutDevice(playoutDevice);
        this.config.setRecordingDevice(recordingDevice);
        ((AudioSettingsView)this.view).setAudioPlayoutDevices(playoutDevices);
        ((AudioSettingsView)this.view).setAudioRecordingDevices(recordingDevices);
        ((AudioSettingsView)this.view).setAudioPlayoutDevice(this.config.playoutDeviceProperty());
        ((AudioSettingsView)this.view).setAudioRecordingDevice(this.config.recordingDeviceProperty());
        ((AudioSettingsView)this.view).setReceiveAudio(this.config.receiveAudioProperty());
        ((AudioSettingsView)this.view).setSendAudio(this.config.sendAudioProperty());
        audioModule.dispose();
    }

    private AudioDevice getAudioDevice(List<AudioDevice> devices, AudioDevice device) {
        return devices.stream().filter(dev -> dev.equals((Object)device)).findFirst().orElse(devices.get(0));
    }
}

