/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.net.codec;

import dev.onvoid.webrtc.RTCIceCandidate;
import dev.onvoid.webrtc.RTCSdpType;
import dev.onvoid.webrtc.RTCSessionDescription;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonWriter;

public class JsonCodec {
    public String encode(Object obj) throws IOException {
        JsonObjectBuilder builder = null;
        if (obj instanceof RTCSessionDescription) {
            RTCSessionDescription desc = (RTCSessionDescription)obj;
            builder = Json.createObjectBuilder();
            builder.add("sdp", desc.sdp);
            builder.add("type", desc.sdpType.toString().toLowerCase());
        } else if (obj instanceof RTCIceCandidate) {
            RTCIceCandidate candidate = (RTCIceCandidate)obj;
            builder = Json.createObjectBuilder();
            builder.add("candidate", candidate.sdp);
            builder.add("sdpMid", candidate.sdpMid);
            builder.add("sdpMLineIndex", candidate.sdpMLineIndex);
        }
        if (Objects.isNull(builder)) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = Json.createWriter((Writer)stringWriter);
        writer.writeObject(builder.build());
        writer.close();
        return stringWriter.toString();
    }

    public Object decode(String json) throws IOException {
        JsonReader reader = Json.createReader((Reader)new StringReader(json));
        JsonObject jsonObject = reader.readObject();
        RTCIceCandidate result = null;
        if (jsonObject.containsKey((Object)"sdp") && jsonObject.containsKey((Object)"type")) {
            RTCSdpType rtcType;
            String sdp = jsonObject.getString("sdp");
            String type = jsonObject.getString("type");
            if (type.equals("offer")) {
                rtcType = RTCSdpType.OFFER;
            } else if (type.equals("answer")) {
                rtcType = RTCSdpType.ANSWER;
            } else {
                throw new IOException("Invalid RTCSdpType");
            }
            result = new RTCSessionDescription(rtcType, sdp);
        } else if (jsonObject.containsKey((Object)"candidate")) {
            String candidate = jsonObject.getString("candidate");
            String sdpMid = jsonObject.getString("sdpMid");
            int sdpMLineIndex = jsonObject.getInt("sdpMLineIndex");
            result = new RTCIceCandidate(sdpMid, sdpMLineIndex, candidate, null);
        }
        reader.close();
        return result;
    }
}

