/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.net;

import dev.onvoid.webrtc.CreateSessionDescriptionObserver;
import dev.onvoid.webrtc.PeerConnectionFactory;
import dev.onvoid.webrtc.PeerConnectionObserver;
import dev.onvoid.webrtc.RTCAnswerOptions;
import dev.onvoid.webrtc.RTCDataChannel;
import dev.onvoid.webrtc.RTCDataChannelBuffer;
import dev.onvoid.webrtc.RTCDataChannelInit;
import dev.onvoid.webrtc.RTCDataChannelObserver;
import dev.onvoid.webrtc.RTCIceCandidate;
import dev.onvoid.webrtc.RTCOfferOptions;
import dev.onvoid.webrtc.RTCPeerConnection;
import dev.onvoid.webrtc.RTCPeerConnectionState;
import dev.onvoid.webrtc.RTCRtpReceiver;
import dev.onvoid.webrtc.RTCRtpSender;
import dev.onvoid.webrtc.RTCRtpTransceiver;
import dev.onvoid.webrtc.RTCRtpTransceiverDirection;
import dev.onvoid.webrtc.RTCSdpType;
import dev.onvoid.webrtc.RTCSessionDescription;
import dev.onvoid.webrtc.SetSessionDescriptionObserver;
import dev.onvoid.webrtc.demo.config.Configuration;
import dev.onvoid.webrtc.demo.config.DesktopCaptureConfiguration;
import dev.onvoid.webrtc.demo.config.VideoConfiguration;
import dev.onvoid.webrtc.demo.model.Contact;
import dev.onvoid.webrtc.demo.model.message.ChatMessage;
import dev.onvoid.webrtc.demo.net.PeerConnectionContext;
import dev.onvoid.webrtc.demo.net.SignalingClient;
import dev.onvoid.webrtc.demo.net.codec.JsonBCodec;
import dev.onvoid.webrtc.media.MediaSource;
import dev.onvoid.webrtc.media.MediaStreamTrack;
import dev.onvoid.webrtc.media.audio.AudioOptions;
import dev.onvoid.webrtc.media.audio.AudioSource;
import dev.onvoid.webrtc.media.audio.AudioTrack;
import dev.onvoid.webrtc.media.video.VideoCaptureCapability;
import dev.onvoid.webrtc.media.video.VideoDesktopSource;
import dev.onvoid.webrtc.media.video.VideoDevice;
import dev.onvoid.webrtc.media.video.VideoDeviceSource;
import dev.onvoid.webrtc.media.video.VideoFrame;
import dev.onvoid.webrtc.media.video.VideoSource;
import dev.onvoid.webrtc.media.video.VideoTrack;
import dev.onvoid.webrtc.media.video.VideoTrackSink;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class PeerConnectionClient
implements PeerConnectionObserver {
    private static System.Logger LOGGER = System.getLogger(PeerConnectionClient.class.getName());
    private final ExecutorService executor;
    private final Configuration config;
    private final SignalingClient signalingClient;
    private final Contact contact;
    private final JsonBCodec dataCodec;
    private Timer statsTimer;
    private PeerConnectionFactory factory;
    private RTCPeerConnection peerConnection;
    private RTCDataChannel dataChannel;
    private RTCDataChannel remoteDataChannel;
    private List<RTCIceCandidate> queuedRemoteCandidates;
    private PeerConnectionContext peerConnectionContext;
    private VideoDesktopSource desktopSource;
    private VideoDeviceSource videoSource;

    public PeerConnectionClient(Configuration config, Contact contact, PeerConnectionContext context, SignalingClient signalingClient, ExecutorService executor) {
        this.config = config;
        this.contact = contact;
        this.peerConnectionContext = context;
        this.signalingClient = signalingClient;
        this.executor = executor;
        this.dataCodec = new JsonBCodec();
        this.queuedRemoteCandidates = new ArrayList<RTCIceCandidate>();
        this.executeAndWait(() -> {
            this.factory = new PeerConnectionFactory();
            this.peerConnection = this.factory.createPeerConnection(config.getRTCConfig(), (PeerConnectionObserver)this);
        });
    }

    public void enableStatsEvents(boolean enable, int periodMs) {
        if (enable) {
            try {
                this.statsTimer = new Timer();
                this.statsTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        PeerConnectionClient.this.getStats();
                    }
                }, 0L, (long)periodMs);
            }
            catch (Exception e) {
                LOGGER.log(System.Logger.Level.ERROR, "Can not schedule statistics timer", (Throwable)e);
            }
        } else {
            this.statsTimer.cancel();
        }
    }

    public boolean hasLocalVideoStream() {
        return Objects.nonNull(this.videoSource);
    }

    public boolean hasRemoteVideoStream() {
        RTCRtpReceiver[] receivers = this.peerConnection.getReceivers();
        if (Objects.nonNull(receivers)) {
            for (RTCRtpReceiver receiver : receivers) {
                if (!receiver.getTrack().getKind().equals("video")) continue;
                return true;
            }
        }
        return false;
    }

    public void onRenegotiationNeeded() {
        if (Objects.nonNull(this.peerConnection.getRemoteDescription())) {
            LOGGER.log(System.Logger.Level.INFO, "Renegotiation needed");
        }
    }

    public void onConnectionChange(RTCPeerConnectionState state) {
        this.notify(this.peerConnectionContext.onPeerConnectionState, state);
    }

    public void onDataChannel(RTCDataChannel channel) {
        this.remoteDataChannel = channel;
        this.initDataChannel(channel);
    }

    public void onIceCandidate(RTCIceCandidate candidate) {
        if (Objects.isNull(this.peerConnection)) {
            LOGGER.log(System.Logger.Level.ERROR, "PeerConnection was not initialized");
            return;
        }
        try {
            this.signalingClient.send(this.contact, candidate);
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.ERROR, "Send RTCIceCandidate failed", (Throwable)e);
        }
    }

    public void onTrack(RTCRtpTransceiver transceiver) {
        MediaStreamTrack track = transceiver.getReceiver().getTrack();
        if (track.getKind().equals("video")) {
            VideoTrack videoTrack = (VideoTrack)track;
            videoTrack.addSink(frame -> this.publishFrame(this.peerConnectionContext.onRemoteFrame, frame));
            this.notify(this.peerConnectionContext.onRemoteVideoStream, Boolean.valueOf(true));
        }
    }

    public void onRemoveTrack(RTCRtpReceiver receiver) {
        MediaStreamTrack track = receiver.getTrack();
        if (track.getKind().equals("video")) {
            this.notify(this.peerConnectionContext.onRemoteVideoStream, Boolean.valueOf(false));
        }
    }

    public void setDesktopActive(boolean active) {
        RTCRtpSender[] senders = this.peerConnection.getSenders();
        if (Objects.nonNull(senders)) {
            for (RTCRtpSender sender : senders) {
                MediaStreamTrack track = sender.getTrack();
                if (!track.getKind().equals("video") || !track.getId().equals("desktopTrack")) continue;
                track.setEnabled(active);
                LOGGER.log(System.Logger.Level.INFO, "Track \"{0}\" set enabled to \"{1}\"", track.getId(), active);
            }
        }
    }

    public void setMicrophoneActive(boolean active) {
        RTCRtpSender[] senders = this.peerConnection.getSenders();
        if (Objects.nonNull(senders)) {
            for (RTCRtpSender sender : senders) {
                MediaStreamTrack track = sender.getTrack();
                if (!track.getKind().equals("audio")) continue;
                track.setEnabled(active);
                LOGGER.log(System.Logger.Level.INFO, "Track \"{0}\" set enabled to \"{1}\"", track.getId(), active);
            }
        }
    }

    public void setCameraActive(boolean active) {
        RTCRtpSender[] senders = this.peerConnection.getSenders();
        if (Objects.nonNull(senders)) {
            for (RTCRtpSender sender : senders) {
                MediaStreamTrack track = sender.getTrack();
                if (!track.getKind().equals("video")) continue;
                track.setEnabled(active);
                LOGGER.log(System.Logger.Level.INFO, "Track \"{0}\" set enabled to \"{1}\"", track.getId(), active);
            }
        }
    }

    public CompletableFuture<Void> close() {
        return CompletableFuture.runAsync(() -> {
            if (Objects.nonNull(this.statsTimer)) {
                this.statsTimer.cancel();
            }
            if (Objects.nonNull(this.desktopSource)) {
                this.desktopSource.stop();
                this.desktopSource.dispose();
                this.desktopSource = null;
            }
            if (Objects.nonNull(this.videoSource)) {
                this.videoSource.stop();
                this.videoSource.dispose();
                this.videoSource = null;
            }
            if (Objects.nonNull(this.dataChannel)) {
                this.dataChannel.unregisterObserver();
                this.dataChannel.close();
                this.dataChannel.dispose();
                this.dataChannel = null;
            }
            if (Objects.nonNull(this.remoteDataChannel)) {
                this.remoteDataChannel.unregisterObserver();
                this.remoteDataChannel.close();
                this.remoteDataChannel.dispose();
                this.remoteDataChannel = null;
            }
            if (Objects.nonNull(this.peerConnection)) {
                this.peerConnection.close();
                this.peerConnection = null;
            }
            if (Objects.nonNull(this.factory)) {
                this.factory.dispose();
                this.factory = null;
            }
        }, this.executor);
    }

    public void initCall() {
        this.createOffer();
    }

    public void establishDataLink() {
        this.execute(() -> {
            this.initMedia();
            this.addDataChannel();
            this.createOffer();
        });
    }

    public void establishMediaLinks() {
        this.addAudio(this.peerConnectionContext.audioDirection);
        this.addVideo(this.peerConnectionContext.videoDirection);
        this.createOffer();
    }

    public CompletableFuture<Void> sendMessage(ChatMessage message) {
        return CompletableFuture.runAsync(() -> {
            if (Objects.isNull(this.dataChannel)) {
                throw new CompletionException("RTCDataChannel was not initialized or negotiated", null);
            }
            try {
                String encoded = this.dataCodec.encode(message);
                ByteBuffer data = ByteBuffer.wrap(encoded.getBytes(StandardCharsets.UTF_8));
                RTCDataChannelBuffer buffer = new RTCDataChannelBuffer(data, false);
                this.dataChannel.send(buffer);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, this.executor);
    }

    private void initMedia() {
        this.addAudio(this.peerConnectionContext.audioDirection);
        this.addVideo(this.peerConnectionContext.videoDirection);
    }

    private void addAudio(RTCRtpTransceiverDirection direction) {
        if (direction == RTCRtpTransceiverDirection.INACTIVE) {
            return;
        }
        AudioOptions audioOptions = new AudioOptions();
        if (direction != RTCRtpTransceiverDirection.SEND_ONLY) {
            audioOptions.echoCancellation = true;
            audioOptions.noiseSuppression = true;
        }
        AudioSource audioSource = this.factory.createAudioSource(audioOptions);
        AudioTrack audioTrack = this.factory.createAudioTrack("audioTrack", audioSource);
        this.peerConnection.addTrack((MediaStreamTrack)audioTrack, List.of("stream"));
        for (RTCRtpTransceiver transceiver : this.peerConnection.getTransceivers()) {
            MediaStreamTrack track = transceiver.getSender().getTrack();
            if (!Objects.nonNull(track) || !track.getKind().equals("audio")) continue;
            transceiver.setDirection(direction);
            break;
        }
    }

    private void addVideo(RTCRtpTransceiverDirection direction) {
        if (direction == RTCRtpTransceiverDirection.INACTIVE) {
            return;
        }
        VideoConfiguration videoConfig = this.config.getVideoConfiguration();
        VideoDevice device = videoConfig.getCaptureDevice();
        VideoCaptureCapability capability = videoConfig.getCaptureCapability();
        this.videoSource = new VideoDeviceSource();
        if (Objects.nonNull(device)) {
            this.videoSource.setVideoCaptureDevice(device);
        }
        if (Objects.nonNull(capability)) {
            this.videoSource.setVideoCaptureCapability(capability);
        }
        VideoTrack videoTrack = this.factory.createVideoTrack("videoTrack", (VideoSource)this.videoSource);
        if (direction == RTCRtpTransceiverDirection.SEND_ONLY || direction == RTCRtpTransceiverDirection.SEND_RECV) {
            VideoTrackSink sink = frame -> this.publishFrame(this.peerConnectionContext.onLocalFrame, frame);
            videoTrack.addSink(sink);
            this.videoSource.start();
        }
        this.peerConnection.addTrack((MediaStreamTrack)videoTrack, List.of("stream"));
        for (RTCRtpTransceiver transceiver : this.peerConnection.getTransceivers()) {
            MediaStreamTrack track = transceiver.getSender().getTrack();
            if (!Objects.nonNull(track) || !track.getKind().equals("video")) continue;
            transceiver.setDirection(direction);
            break;
        }
        this.notify(this.peerConnectionContext.onLocalVideoStream, Boolean.valueOf(this.videoSource.getState() == MediaSource.State.LIVE));
    }

    private void addDesktop(RTCRtpTransceiverDirection direction) {
        VideoTrack videoTrack;
        block6: {
            block5: {
                if (direction == RTCRtpTransceiverDirection.INACTIVE) {
                    return;
                }
                DesktopCaptureConfiguration desktopConfig = this.config.getDesktopCaptureConfiguration();
                this.desktopSource = new VideoDesktopSource();
                this.desktopSource.setDesktopCapturer(null);
                this.desktopSource.setFrameRate(desktopConfig.getFrameRate().intValue());
                videoTrack = this.factory.createVideoTrack("desktopTrack", (VideoSource)this.desktopSource);
                if (direction == RTCRtpTransceiverDirection.SEND_ONLY) break block5;
                if (direction != RTCRtpTransceiverDirection.SEND_RECV) break block6;
            }
            VideoTrackSink sink = System.out::println;
            videoTrack.addSink(sink);
            this.desktopSource.start();
        }
        this.peerConnection.addTrack((MediaStreamTrack)videoTrack, List.of("stream"));
        for (RTCRtpTransceiver transceiver : this.peerConnection.getTransceivers()) {
            MediaStreamTrack track = transceiver.getSender().getTrack();
            if (!Objects.nonNull(track) || !track.getKind().equals("video") || !track.getId().equals("desktopTrack")) continue;
            transceiver.setDirection(direction);
            break;
        }
    }

    private void addDataChannel() {
        RTCDataChannelInit dict = new RTCDataChannelInit();
        dict.protocol = "demo-messaging";
        this.dataChannel = this.peerConnection.createDataChannel("data", dict);
    }

    private void initDataChannel(final RTCDataChannel channel) {
        channel.registerObserver(new RTCDataChannelObserver(){

            public void onBufferedAmountChange(long previousAmount) {
                PeerConnectionClient.this.execute(() -> LOGGER.log(System.Logger.Level.INFO, "RTCDataChannel \"{0}\" buffered amount changed to {1}", channel.getLabel(), previousAmount));
            }

            public void onStateChange() {
                PeerConnectionClient.this.execute(() -> LOGGER.log(System.Logger.Level.INFO, "RTCDataChannel \"{0}\" state: {1}", channel.getLabel(), channel.getState()));
            }

            public void onMessage(RTCDataChannelBuffer buffer) {
                PeerConnectionClient.this.execute(() -> {
                    try {
                        PeerConnectionClient.this.decodeMessage(buffer);
                    }
                    catch (Exception e) {
                        LOGGER.log(System.Logger.Level.ERROR, "Decode data channel message failed", (Throwable)e);
                    }
                });
            }
        });
    }

    private void getStats() {
        this.execute(() -> this.peerConnection.getStats(report -> {
            if (Objects.nonNull(this.peerConnectionContext.onStatsReport)) {
                this.peerConnectionContext.onStatsReport.accept(report);
            }
        }));
    }

    private void decodeMessage(RTCDataChannelBuffer buffer) {
        byte[] payload;
        ByteBuffer byteBuffer = buffer.data;
        if (byteBuffer.hasArray()) {
            payload = byteBuffer.array();
        } else {
            payload = new byte[byteBuffer.limit()];
            byteBuffer.get(payload);
        }
        if (Objects.nonNull(this.peerConnectionContext.onMessage)) {
            String data = new String(payload, StandardCharsets.UTF_8);
            ChatMessage message = this.dataCodec.decode(data, ChatMessage.class);
            message.setOrigin(ChatMessage.Origin.REMOTE);
            message.setTime(LocalTime.now());
            this.peerConnectionContext.onMessage.accept(this.contact, message);
        }
    }

    public void setSessionDescription(RTCSessionDescription description) {
        this.execute(() -> {
            final boolean receivingCall = description.sdpType == RTCSdpType.OFFER;
            this.peerConnection.setRemoteDescription(description, (SetSessionDescriptionObserver)new SetSDObserver(){

                @Override
                public void onSuccess() {
                    super.onSuccess();
                    if (receivingCall) {
                        PeerConnectionClient.this.initMedia();
                        PeerConnectionClient.this.createAnswer();
                    }
                }
            });
        });
    }

    public void addIceCandidate(RTCIceCandidate candidate) {
        this.execute(() -> {
            if (Objects.nonNull(this.queuedRemoteCandidates)) {
                this.queuedRemoteCandidates.add(candidate);
            } else {
                this.peerConnection.addIceCandidate(candidate);
            }
        });
    }

    private void drainIceCandidates() {
        if (Objects.nonNull(this.queuedRemoteCandidates)) {
            LOGGER.log(System.Logger.Level.INFO, "Add " + this.queuedRemoteCandidates.size() + " remote candidates");
            this.queuedRemoteCandidates.forEach(arg_0 -> ((RTCPeerConnection)this.peerConnection).addIceCandidate(arg_0));
            this.queuedRemoteCandidates = null;
        }
    }

    private void createOffer() {
        RTCOfferOptions options = new RTCOfferOptions();
        this.peerConnection.createOffer(options, (CreateSessionDescriptionObserver)new CreateSDObserver());
    }

    private void createAnswer() {
        RTCAnswerOptions options = new RTCAnswerOptions();
        this.peerConnection.createAnswer(options, (CreateSessionDescriptionObserver)new CreateSDObserver());
    }

    private void setLocalDescription(final RTCSessionDescription description) {
        this.peerConnection.setLocalDescription(description, (SetSessionDescriptionObserver)new SetSDObserver(){

            @Override
            public void onSuccess() {
                super.onSuccess();
                try {
                    PeerConnectionClient.this.signalingClient.send(PeerConnectionClient.this.contact, description);
                }
                catch (Exception e) {
                    LOGGER.log(System.Logger.Level.ERROR, "Send RTCSessionDescription failed", (Throwable)e);
                }
            }
        });
    }

    private void publishFrame(Consumer<VideoFrame> consumer, VideoFrame frame) {
        if (Objects.isNull(consumer)) {
            return;
        }
        frame.retain();
        consumer.accept(frame);
        frame.release();
    }

    private void publishFrame(BiConsumer<Contact, VideoFrame> consumer, VideoFrame frame) {
        if (Objects.isNull(consumer)) {
            return;
        }
        frame.retain();
        consumer.accept(this.contact, frame);
        frame.release();
    }

    private <T> void notify(Consumer<T> consumer, T value) {
        if (Objects.nonNull(consumer)) {
            this.execute(() -> consumer.accept(value));
        }
    }

    private <T> void notify(BiConsumer<Contact, T> consumer, T value) {
        if (Objects.nonNull(consumer)) {
            this.execute(() -> consumer.accept(this.contact, value));
        }
    }

    private void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    private void executeAndWait(Runnable runnable) {
        try {
            this.executor.submit(runnable).get();
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.ERROR, "Execute task failed");
        }
    }

    private class CreateSDObserver
    implements CreateSessionDescriptionObserver {
        private CreateSDObserver() {
        }

        public void onSuccess(RTCSessionDescription description) {
            PeerConnectionClient.this.execute(() -> PeerConnectionClient.this.setLocalDescription(description));
        }

        public void onFailure(String error) {
            PeerConnectionClient.this.execute(() -> LOGGER.log(System.Logger.Level.ERROR, "Create RTCSessionDescription failed: " + error));
        }
    }

    private class SetSDObserver
    implements SetSessionDescriptionObserver {
        private SetSDObserver() {
        }

        public void onSuccess() {
            PeerConnectionClient.this.execute(() -> {
                if (Objects.nonNull(PeerConnectionClient.this.peerConnection.getLocalDescription()) && Objects.nonNull(PeerConnectionClient.this.peerConnection.getRemoteDescription())) {
                    PeerConnectionClient.this.drainIceCandidates();
                }
            });
        }

        public void onFailure(String error) {
            PeerConnectionClient.this.execute(() -> LOGGER.log(System.Logger.Level.ERROR, "Set RTCSessionDescription failed: " + error));
        }
    }
}

