/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.net;

import dev.onvoid.webrtc.RTCIceCandidate;
import dev.onvoid.webrtc.RTCSessionDescription;
import dev.onvoid.webrtc.demo.model.Contact;
import dev.onvoid.webrtc.demo.net.SignalingClient;
import dev.onvoid.webrtc.demo.net.codec.JsonCodec;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Named;

public class HttpSignalingClient
implements SignalingClient {
    private static System.Logger LOGGER = System.getLogger(HttpSignalingClient.class.getName());
    private final String serverUrl;
    private final HttpClient client;
    private final Set<Contact> remotePeers;
    private final JsonCodec messageCodec;
    private long myId;
    private BiConsumer<Contact, Boolean> contactEventConsumer;
    private BiConsumer<Contact, RTCIceCandidate> iceCandidateConsumer;
    private BiConsumer<Contact, RTCSessionDescription> sessionDescConsumer;

    @Inject
    public HttpSignalingClient(@Named(value="Signaling Server") String server, @Named(value="Signaling Server Port") int port) {
        this.serverUrl = "http://" + server + ":" + port;
        this.client = HttpClient.newHttpClient();
        this.remotePeers = new HashSet<Contact>();
        this.messageCodec = new JsonCodec();
    }

    @Override
    public Set<Contact> getRemotePeers() {
        return this.remotePeers;
    }

    @Override
    public void setContactEventConsumer(BiConsumer<Contact, Boolean> consumer) {
        this.contactEventConsumer = consumer;
    }

    @Override
    public void setIceCandidateConsumer(BiConsumer<Contact, RTCIceCandidate> consumer) {
        this.iceCandidateConsumer = consumer;
    }

    @Override
    public void setSessionDescriptionConsumer(BiConsumer<Contact, RTCSessionDescription> consumer) {
        this.sessionDescConsumer = consumer;
    }

    @Override
    public void login(Contact asContact) throws Exception {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.serverUrl + "/sign_in?" + asContact.getName())).build();
        HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            return;
        }
        String peerList = response.body();
        String[] peers = peerList.split("\n");
        this.myId = Integer.parseInt(peers[0].split(",")[1]);
        LOGGER.log(System.Logger.Level.INFO, "Signed in as \"{0}\" with id \"{1}\"", asContact.getName(), this.myId);
        for (String peer : peers) {
            this.updatePeers(peer);
        }
        this.startHangingGet();
    }

    @Override
    public void logout() {
        if (this.myId < 1L) {
            return;
        }
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.serverUrl + "/sign_out?peer_id=" + this.myId)).build();
        this.myId = -1L;
        this.client.sendAsync(request, HttpResponse.BodyHandlers.discarding());
    }

    @Override
    public void send(Contact contact, Object obj) throws Exception {
        this.send(contact, this.messageCodec.encode(obj));
    }

    private void send(Contact contact, String body) throws Exception {
        if (this.myId < 1L) {
            throw new IllegalStateException("Not connected");
        }
        if (this.myId == Long.parseLong(contact.getId())) {
            throw new IllegalStateException("Can't send a message to oneself");
        }
        LOGGER.log(System.Logger.Level.INFO, "Sending: " + body);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.serverUrl + "/message?peer_id=" + this.myId + "&to=" + contact.getId())).header("Content-Type", "text/plain").POST(HttpRequest.BodyPublishers.ofString(body)).build();
        try {
            this.client.send(request, HttpResponse.BodyHandlers.discarding());
        }
        catch (InterruptedException e) {
            LOGGER.log(System.Logger.Level.ERROR, "Send message failed", (Throwable)e);
        }
    }

    private void startHangingGet() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.serverUrl + "/wait?peer_id=" + this.myId)).build();
        CompletableFuture<HttpResponse<String>> future = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        ((CompletableFuture)future.thenApply(response -> {
            long remotePeerId = response.headers().firstValueAsLong("Pragma").orElse(0L);
            if (remotePeerId == this.myId) {
                this.handleServerNotification((String)response.body());
            } else {
                this.handlePeerMessage(this.findContact(remotePeerId), (String)response.body());
            }
            return response;
        })).thenRun(this::startHangingGet);
    }

    private Contact findContact(long id) {
        return this.remotePeers.stream().filter(contact -> Long.parseLong(contact.getId()) == id).findFirst().orElseThrow();
    }

    private void handlePeerMessage(Contact contact, String body) {
        Object decoded;
        try {
            decoded = this.messageCodec.decode(body);
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.ERROR, "Decode message failed: " + body, (Throwable)e);
            return;
        }
        if (decoded instanceof RTCIceCandidate && Objects.nonNull(this.iceCandidateConsumer)) {
            this.iceCandidateConsumer.accept(contact, (RTCIceCandidate)decoded);
        } else if (decoded instanceof RTCSessionDescription && Objects.nonNull(this.sessionDescConsumer)) {
            this.sessionDescConsumer.accept(contact, (RTCSessionDescription)decoded);
        }
    }

    private void handleServerNotification(String body) {
        this.updatePeers(body);
    }

    private void updatePeers(String peer) {
        boolean offline;
        if (peer.isEmpty() || peer.isBlank()) {
            return;
        }
        String[] parsed = peer.split(",");
        Contact contact = new Contact(parsed[1], parsed[0]);
        int id = Integer.parseInt(contact.getId());
        boolean bl = offline = Integer.parseInt(parsed[2].trim()) == 0;
        if ((long)id == this.myId) {
            return;
        }
        if (offline) {
            this.remotePeers.remove(contact);
        } else {
            this.remotePeers.add(contact);
        }
        if (Objects.nonNull(this.contactEventConsumer)) {
            this.contactEventConsumer.accept(contact, !offline);
        }
    }
}

