/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.config;

import dev.onvoid.webrtc.RTCConfiguration;
import dev.onvoid.webrtc.demo.beans.ObjectProperty;
import dev.onvoid.webrtc.demo.config.AudioConfiguration;
import dev.onvoid.webrtc.demo.config.DesktopCaptureConfiguration;
import dev.onvoid.webrtc.demo.config.VideoConfiguration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.inject.Singleton;

@Singleton
public class Configuration {
    private String version;
    private LocalDateTime buildDate;
    private final ObjectProperty<Locale> locale = new ObjectProperty();
    private AudioConfiguration audioConfig = new AudioConfiguration();
    private VideoConfiguration videoConfig = new VideoConfiguration();
    private DesktopCaptureConfiguration desktopCaptureConfig = new DesktopCaptureConfiguration();
    private RTCConfiguration rtcConfig = new RTCConfiguration();

    public Configuration() {
        this.initMetaData();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public LocalDateTime getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(LocalDateTime date) {
        this.buildDate = date;
    }

    public Locale getLocale() {
        return this.locale.get();
    }

    public void setLocale(Locale locale) {
        this.locale.set(locale);
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.locale;
    }

    public AudioConfiguration getAudioConfiguration() {
        return this.audioConfig;
    }

    public VideoConfiguration getVideoConfiguration() {
        return this.videoConfig;
    }

    public DesktopCaptureConfiguration getDesktopCaptureConfiguration() {
        return this.desktopCaptureConfig;
    }

    public RTCConfiguration getRTCConfig() {
        return this.rtcConfig;
    }

    private void initMetaData() {
        String version = "1.0";
        LocalDateTime date = LocalDateTime.now();
        try {
            Manifest manifest = new Manifest(this.getClass().getResourceAsStream("META-INF/MANIFEST.MF"));
            Attributes attr = manifest.getMainAttributes();
            String buildDateAttr = attr.getValue("Build-Date");
            String versionAttr = attr.getValue("Version");
            if (Objects.nonNull(versionAttr)) {
                version = versionAttr;
            }
            if (Objects.nonNull(buildDateAttr)) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
                date = LocalDateTime.parse(buildDateAttr, formatter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVersion(version);
        this.setBuildDate(date);
    }
}

