/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.beans;

import dev.onvoid.webrtc.demo.beans.ChangeListener;
import dev.onvoid.webrtc.demo.beans.Observable;
import java.lang.ref.WeakReference;

public class WeakChangeListener<T>
implements ChangeListener<T> {
    private final WeakReference<ChangeListener<T>> ref;

    public WeakChangeListener(ChangeListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("Listener must be specified");
        }
        this.ref = new WeakReference<ChangeListener<ChangeListener<T>>>(listener);
    }

    @Override
    public void changed(Observable<? extends T> observable, T oldValue, T newValue) {
        ChangeListener listener = (ChangeListener)this.ref.get();
        if (listener != null) {
            listener.changed(observable, oldValue, newValue);
        } else {
            observable.removeListener(this);
        }
    }
}

