/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.beans;

import dev.onvoid.webrtc.demo.beans.ObjectProperty;
import dev.onvoid.webrtc.demo.beans.Observable;
import java.util.Objects;

public class ImmutableObjectProperty<T>
extends ObjectProperty<T> {
    private ImmutableProperty immutableProperty;

    public ImmutableObjectProperty() {
    }

    public ImmutableObjectProperty(T defaultValue) {
        this.set(defaultValue);
    }

    public ObjectProperty<T> getImmutableProperty() {
        if (Objects.isNull(this.immutableProperty)) {
            this.immutableProperty = new ImmutableProperty();
        }
        return this.immutableProperty;
    }

    @Override
    protected void fireChange(Observable<T> observable, T oldValue, T newValue) {
        super.fireChange(observable, oldValue, newValue);
        if (Objects.nonNull(this.immutableProperty)) {
            this.immutableProperty.fireChange(this.immutableProperty, oldValue, newValue);
        }
    }

    private class ImmutableProperty
    extends ObjectProperty<T> {
        private ImmutableProperty() {
        }

        @Override
        public T get() {
            return ImmutableObjectProperty.this.get();
        }

        @Override
        public void set(T value) {
        }
    }
}

