/*
 * Copyright 2019 Alex Andres
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package dev.onvoid.webrtc.demo.view;

import dev.onvoid.webrtc.demo.model.Contact;
import dev.onvoid.webrtc.demo.model.Contacts;

public interface ContactsView extends View {

	void addChatMessage(ChatMessageView messageView);

	void setContact(Contact contact);

	void addContact(Contact contact);

	void removeContact(Contact contact);

	void setContacts(Contacts contacts);

	void setOnSettings(Action action);

	void setOnShareDesktop(Action action);

	void setOnAudioCall(Action action);

	void setOnVideoCall(Action action);

	void setOnSendMessage(ConsumerAction<String> action);

	void setOnContactSelection(ConsumerAction<Contact> action);

}
