/*
 * Copyright 2019 Alex Andres
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package dev.onvoid.webrtc.demo.beans;

/**
 * Byte property implementation.
 *
 * @author Alex Andres
 */
public class ByteProperty extends ObjectProperty<Byte> {

	/**
	 * Create a ByteProperty with the initial value set to {@code 0}.
	 */
	public ByteProperty() {
		this((byte) 0);
	}

	/**
	 * Create a ByteProperty with the specified initial value.
	 *
	 * @param defaultValue The initial value.
	 */
	public ByteProperty(byte defaultValue) {
		set(defaultValue);
	}

}
