/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.OnnxBertBiEncoder;
import dev.langchain4j.model.embedding.PoolingMode;
import dev.langchain4j.model.embedding.TokenCountEstimator;
import dev.langchain4j.model.output.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractInProcessEmbeddingModel
implements EmbeddingModel,
TokenCountEstimator {
    static OnnxBertBiEncoder loadFromJar(String modelFileName, String vocabularyFileName, PoolingMode poolingMode) {
        InputStream inputStream = AbstractInProcessEmbeddingModel.class.getResourceAsStream("/" + modelFileName);
        return new OnnxBertBiEncoder(inputStream, AbstractInProcessEmbeddingModel.class.getResource("/" + vocabularyFileName), poolingMode);
    }

    static OnnxBertBiEncoder loadFromFileSystem(Path pathToModel) {
        try {
            return new OnnxBertBiEncoder(Files.newInputStream(pathToModel, new OpenOption[0]), AbstractInProcessEmbeddingModel.class.getResource("/bert-vocabulary-en.txt"), PoolingMode.MEAN);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract OnnxBertBiEncoder model();

    public Response<List<Embedding>> embedAll(List<TextSegment> segments) {
        List embeddings = segments.stream().map(segment -> Embedding.from((float[])this.model().embed(segment.text()))).collect(Collectors.toList());
        return Response.from(embeddings);
    }

    public int estimateTokenCount(String text) {
        return this.model().countTokens(text);
    }
}

