// THIS FILE IS AUTO-GENERATED BY KordEnumProcessor.kt, DO NOT EDIT!
@file:Suppress(names = arrayOf("RedundantVisibilityModifier", "IncorrectFormatting",
                "ReplaceArrayOfWithLiteral", "SpellCheckingInspection", "GrazieInspection"))

package dev.kord.common.entity

import kotlin.Any
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.DeprecationLevel
import kotlin.Int
import kotlin.LazyThreadSafetyMode.PUBLICATION
import kotlin.ReplaceWith
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.KSerializer
import kotlinx.serialization.Serializable
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder

/**
 * See [GuildFeature]s in the
 * [Discord Developer Documentation](https://discord.com/developers/docs/resources/guild#guild-object-guild-features).
 */
@Serializable(with = GuildFeature.Serializer::class)
public sealed class GuildFeature(
    /**
     * The raw value used by Discord.
     */
    public val `value`: String,
) {
    public final override fun equals(other: Any?): Boolean = this === other ||
            (other is GuildFeature && this.value == other.value)

    public final override fun hashCode(): Int = value.hashCode()

    public final override fun toString(): String =
            "GuildFeature.${this::class.simpleName}(value=$value)"

    /**
     * An unknown [GuildFeature].
     *
     * This is used as a fallback for [GuildFeature]s that haven't been added to Kord yet.
     */
    public class Unknown(
        `value`: String,
    ) : GuildFeature(value)

    /**
     * Guild has access to set an animated guild banner image.
     */
    public object AnimatedBanner : GuildFeature("ANIMATED_BANNER")

    /**
     * Guild has access to set an animated guild icon.
     */
    public object AnimatedIcon : GuildFeature("ANIMATED_ICON")

    /**
     * Guild is using the old permissions configuration behavior.
     */
    public object ApplicationCommandPermissionsV2 :
            GuildFeature("APPLICATION_COMMAND_PERMISSIONS_V2")

    /**
     * Guild has set up auto moderation rules.
     */
    public object AutoModeration : GuildFeature("AUTO_MODERATION")

    /**
     * Guild has access to set a guild banner image.
     */
    public object Banner : GuildFeature("BANNER")

    /**
     * Guild can enable welcome screen, Membership Screening, stage channels and discovery, and
     * receives community updates.
     */
    public object Community : GuildFeature("COMMUNITY")

    /**
     * Guild has enabled monetization.
     */
    public object CreatorMonetizableProvisional : GuildFeature("CREATOR_MONETIZABLE_PROVISIONAL")

    /**
     * Guild has enabled the role subscription promo page.
     */
    public object CreatorStorePage : GuildFeature("CREATOR_STORE_PAGE")

    /**
     * Guild has been set as a support server on the App Directory.
     */
    public object DeveloperSupportServer : GuildFeature("DEVELOPER_SUPPORT_SERVER")

    /**
     * Guild is able to be discovered in the directory.
     */
    public object Discoverable : GuildFeature("DISCOVERABLE")

    /**
     * Guild is able to be featured in the directory.
     */
    public object Featurable : GuildFeature("FEATURABLE")

    /**
     * Guild has paused invites, preventing new users from joining.
     */
    public object InvitesDisabled : GuildFeature("INVITES_DISABLED")

    /**
     * Guild has access to set an invite splash background.
     */
    public object InviteSplash : GuildFeature("INVITE_SPLASH")

    /**
     * Guild has enabled Membership Screening.
     */
    public object MemberVerificationGateEnabled : GuildFeature("MEMBER_VERIFICATION_GATE_ENABLED")

    /**
     * Guild has enabled monetization.
     */
    @Deprecated(
        level = DeprecationLevel.HIDDEN,
        message = "Replaced by CreatorMonetizableProvisional.",
        replaceWith = ReplaceWith(expression = "GuildFeature.CreatorMonetizableProvisional", imports
                    = arrayOf("dev.kord.common.entitiy.GuildFeature")),
    )
    public object MonetizationEnabled : GuildFeature("MONETIZATION_ENABLED")

    /**
     * Guild has increased custom sticker slots.
     */
    public object MoreStickers : GuildFeature("MORE_STICKERS")

    /**
     * Guild has access to create announcement channels.
     */
    public object News : GuildFeature("NEWS")

    /**
     * Guild is partnered.
     */
    public object Partnered : GuildFeature("PARTNERED")

    /**
     * Guild can be previewed before joining via Membership Screening or the directory.
     */
    public object PreviewEnabled : GuildFeature("PREVIEW_ENABLED")

    /**
     * Guild has access to create private threads
     */
    @Deprecated(
        level = DeprecationLevel.HIDDEN,
        message = "Creating a private thread no longer requires the server to be boosted.",
    )
    public object PrivateThreads : GuildFeature("PRIVATE_THREADS")

    /**
     * Guild has disabled alerts for join raids in the configured safety alerts channel.
     */
    public object RaidAlertsDisabled : GuildFeature("RAID_ALERTS_DISABLED")

    /**
     * Guild is able to set role icons.
     */
    public object RoleIcons : GuildFeature("ROLE_ICONS")

    /**
     * Guild has role subscriptions that can be purchased.
     */
    public object RoleSubscriptionsAvailableForPurchase :
            GuildFeature("ROLE_SUBSCRIPTIONS_AVAILABLE_FOR_PURCHASE")

    /**
     * Guild has enabled role subscriptions.
     */
    public object RoleSubscriptionsEnabled : GuildFeature("ROLE_SUBSCRIPTIONS_ENABLED")

    /**
     * Guild has enabled ticketed events.
     */
    public object TicketedEventsEnabled : GuildFeature("TICKETED_EVENTS_ENABLED")

    /**
     * Guild has access to set a vanity URL.
     */
    public object VanityUrl : GuildFeature("VANITY_URL")

    /**
     * Guild is verified.
     */
    public object Verified : GuildFeature("VERIFIED")

    /**
     * Guild has access to set 384kbps bitrate in voice (previously VIP voice servers).
     */
    public object VIPRegions : GuildFeature("VIP_REGIONS")

    /**
     * Guild has enabled the welcome screen.
     */
    public object WelcomeScreenEnabled : GuildFeature("WELCOME_SCREEN_ENABLED")

    internal object Serializer : KSerializer<GuildFeature> {
        public override val descriptor: SerialDescriptor =
                PrimitiveSerialDescriptor("dev.kord.common.entity.GuildFeature",
                PrimitiveKind.STRING)

        public override fun serialize(encoder: Encoder, `value`: GuildFeature) =
                encoder.encodeString(value.value)

        public override fun deserialize(decoder: Decoder) =
                when (val value = decoder.decodeString()) {
            "ANIMATED_BANNER" -> AnimatedBanner
            "ANIMATED_ICON" -> AnimatedIcon
            "APPLICATION_COMMAND_PERMISSIONS_V2" -> ApplicationCommandPermissionsV2
            "AUTO_MODERATION" -> AutoModeration
            "BANNER" -> Banner
            "COMMUNITY" -> Community
            "CREATOR_MONETIZABLE_PROVISIONAL" -> CreatorMonetizableProvisional
            "CREATOR_STORE_PAGE" -> CreatorStorePage
            "DEVELOPER_SUPPORT_SERVER" -> DeveloperSupportServer
            "DISCOVERABLE" -> Discoverable
            "FEATURABLE" -> Featurable
            "INVITES_DISABLED" -> InvitesDisabled
            "INVITE_SPLASH" -> InviteSplash
            "MEMBER_VERIFICATION_GATE_ENABLED" -> MemberVerificationGateEnabled
            "MONETIZATION_ENABLED" -> @Suppress("DEPRECATION_ERROR") MonetizationEnabled
            "MORE_STICKERS" -> MoreStickers
            "NEWS" -> News
            "PARTNERED" -> Partnered
            "PREVIEW_ENABLED" -> PreviewEnabled
            "PRIVATE_THREADS" -> @Suppress("DEPRECATION_ERROR") PrivateThreads
            "RAID_ALERTS_DISABLED" -> RaidAlertsDisabled
            "ROLE_ICONS" -> RoleIcons
            "ROLE_SUBSCRIPTIONS_AVAILABLE_FOR_PURCHASE" -> RoleSubscriptionsAvailableForPurchase
            "ROLE_SUBSCRIPTIONS_ENABLED" -> RoleSubscriptionsEnabled
            "TICKETED_EVENTS_ENABLED" -> TicketedEventsEnabled
            "VANITY_URL" -> VanityUrl
            "VERIFIED" -> Verified
            "VIP_REGIONS" -> VIPRegions
            "WELCOME_SCREEN_ENABLED" -> WelcomeScreenEnabled
            else -> Unknown(value)
        }
    }

    public companion object {
        /**
         * A [List] of all known [GuildFeature]s.
         */
        public val entries: List<GuildFeature> by lazy(mode = PUBLICATION) {
            listOf(
                AnimatedBanner,
                AnimatedIcon,
                ApplicationCommandPermissionsV2,
                AutoModeration,
                Banner,
                Community,
                CreatorMonetizableProvisional,
                CreatorStorePage,
                DeveloperSupportServer,
                Discoverable,
                Featurable,
                InvitesDisabled,
                InviteSplash,
                MemberVerificationGateEnabled,
                @Suppress("DEPRECATION_ERROR") MonetizationEnabled,
                MoreStickers,
                News,
                Partnered,
                PreviewEnabled,
                @Suppress("DEPRECATION_ERROR") PrivateThreads,
                RaidAlertsDisabled,
                RoleIcons,
                RoleSubscriptionsAvailableForPurchase,
                RoleSubscriptionsEnabled,
                TicketedEventsEnabled,
                VanityUrl,
                Verified,
                VIPRegions,
                WelcomeScreenEnabled,
            )
        }

    }
}
