// THIS FILE IS AUTO-GENERATED BY KordEnumProcessor.kt, DO NOT EDIT!
@file:Suppress(names = arrayOf("RedundantVisibilityModifier", "IncorrectFormatting",
                "ReplaceArrayOfWithLiteral", "SpellCheckingInspection", "GrazieInspection"))

package dev.kord.common.entity

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.LazyThreadSafetyMode.PUBLICATION
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.KSerializer
import kotlinx.serialization.Serializable
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder

/**
 * See [ActivityType]s in the
 * [Discord Developer Documentation](https://discord.com/developers/docs/topics/gateway-events#activity-object-activity-types).
 */
@Serializable(with = ActivityType.Serializer::class)
public sealed class ActivityType(
    /**
     * The raw code used by Discord.
     */
    public val code: Int,
) {
    public final override fun equals(other: Any?): Boolean = this === other ||
            (other is ActivityType && this.code == other.code)

    public final override fun hashCode(): Int = code.hashCode()

    public final override fun toString(): String =
            "ActivityType.${this::class.simpleName}(code=$code)"

    /**
     * An unknown [ActivityType].
     *
     * This is used as a fallback for [ActivityType]s that haven't been added to Kord yet.
     */
    public class Unknown(
        code: Int,
    ) : ActivityType(code)

    public object Game : ActivityType(0)

    public object Streaming : ActivityType(1)

    public object Listening : ActivityType(2)

    public object Watching : ActivityType(3)

    public object Custom : ActivityType(4)

    public object Competing : ActivityType(5)

    internal object Serializer : KSerializer<ActivityType> {
        public override val descriptor: SerialDescriptor =
                PrimitiveSerialDescriptor("dev.kord.common.entity.ActivityType", PrimitiveKind.INT)

        public override fun serialize(encoder: Encoder, `value`: ActivityType) =
                encoder.encodeInt(value.code)

        public override fun deserialize(decoder: Decoder) = when (val code = decoder.decodeInt()) {
            0 -> Game
            1 -> Streaming
            2 -> Listening
            3 -> Watching
            4 -> Custom
            5 -> Competing
            else -> Unknown(code)
        }
    }

    public companion object {
        /**
         * A [List] of all known [ActivityType]s.
         */
        public val entries: List<ActivityType> by lazy(mode = PUBLICATION) {
            listOf(
                Game,
                Streaming,
                Listening,
                Watching,
                Custom,
                Competing,
            )
        }

    }
}
