/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIConfig;
import dev.jorel.commandapi.nms.NMS;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class InternalConfig {
    private final boolean verboseOutput;
    private final boolean silentLogs;
    private final boolean useLatestNMSVersion;
    private final String message_missingExecutorImplementation;
    private final File dispatcherFile;
    private final Map<JavaPlugin, String[]> pluginsToConvert;
    private final List<String> skipSenderProxy;
    private final List<String> commandsToConvert;
    private final Class<?> nbtContainerClass;
    private final Function<Object, ?> nbtContainerConstructor;
    private final NMS<?> customNMS;

    InternalConfig(FileConfiguration fileConfig, Class<?> nbtContainerClass, Function<Object, ?> nbtContainerConstructor, File dispatcherFile) {
        this.verboseOutput = fileConfig.getBoolean("verbose-outputs");
        this.silentLogs = fileConfig.getBoolean("silent-logs");
        this.useLatestNMSVersion = fileConfig.getBoolean("use-latest-nms-version");
        this.message_missingExecutorImplementation = fileConfig.getString("messages.missing-executor-implementation");
        this.dispatcherFile = fileConfig.getBoolean("create-dispatcher-json") ? dispatcherFile : null;
        this.pluginsToConvert = new HashMap<JavaPlugin, String[]>();
        this.skipSenderProxy = new ArrayList<String>();
        this.commandsToConvert = new ArrayList<String>();
        this.nbtContainerClass = nbtContainerClass;
        this.nbtContainerConstructor = nbtContainerConstructor;
        this.customNMS = null;
        if (!fileConfig.getList("plugins-to-convert").isEmpty() && fileConfig.getMapList("plugins-to-convert").isEmpty()) {
            CommandAPI.getLogger().severe("plugins-to-convert has an invalid type. Did you miss a colon (:) after a plugin name?");
        }
        for (Map map : fileConfig.getMapList("plugins-to-convert")) {
            String[] pluginCommands;
            if (map.values() == null || map.values().size() == 1 && map.values().iterator().next() == null) {
                pluginCommands = new String[]{};
            } else {
                List commands = (List)map.values().iterator().next();
                pluginCommands = commands.toArray(new String[0]);
            }
            String pluginName = (String)map.keySet().iterator().next();
            Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (plugin != null) {
                if (plugin instanceof JavaPlugin) {
                    JavaPlugin javaPlugin = (JavaPlugin)plugin;
                    this.pluginsToConvert.put(javaPlugin, pluginCommands);
                    continue;
                }
                new InvalidPluginException("Plugin " + pluginName + " is not a JavaPlugin!").printStackTrace();
                continue;
            }
            new InvalidPluginException("Could not find a plugin " + pluginName + "! Has it been loaded properly?").printStackTrace();
        }
        for (String pluginName : fileConfig.getStringList("skip-sender-proxy")) {
            if (Bukkit.getPluginManager().getPlugin(pluginName) != null) {
                this.skipSenderProxy.add(pluginName);
                continue;
            }
            new InvalidPluginException("Could not find a plugin " + pluginName + "! Has it been loaded properly?").printStackTrace();
        }
        for (String commandName : fileConfig.getStringList("other-commands-to-convert")) {
            this.commandsToConvert.add(commandName);
        }
    }

    @Deprecated(forRemoval=true)
    public InternalConfig(boolean verbose) {
        this(new CommandAPIConfig().verboseOutput(verbose));
    }

    public InternalConfig(CommandAPIConfig config) {
        this.verboseOutput = config.verboseOutput;
        this.silentLogs = config.silentLogs;
        this.useLatestNMSVersion = config.useLatestNMSVersion;
        this.message_missingExecutorImplementation = config.missingExecutorImplementationMessage;
        this.dispatcherFile = config.dispatcherFile;
        this.pluginsToConvert = new HashMap<JavaPlugin, String[]>();
        this.skipSenderProxy = new ArrayList<String>();
        this.commandsToConvert = new ArrayList<String>();
        this.nbtContainerClass = config.nbtContainerClass;
        this.nbtContainerConstructor = config.nbtContainerConstructor;
        this.customNMS = config.customNMS;
    }

    public boolean hasVerboseOutput() {
        return this.verboseOutput;
    }

    public boolean hasSilentLogs() {
        return this.silentLogs;
    }

    public boolean shouldUseLatestNMSVersion() {
        return this.useLatestNMSVersion;
    }

    public String getMissingImplementationMessage() {
        return this.message_missingExecutorImplementation;
    }

    public File getDispatcherFile() {
        return this.dispatcherFile;
    }

    public Set<Map.Entry<JavaPlugin, String[]>> getPluginsToConvert() {
        return this.pluginsToConvert.entrySet();
    }

    public boolean shouldSkipSenderProxy(Plugin plugin) {
        return this.skipSenderProxy.contains(plugin.getName());
    }

    public boolean shouldSkipSenderProxy(String commandName) {
        return this.skipSenderProxy.contains(commandName);
    }

    public List<String> getCommandsToConvert() {
        return this.commandsToConvert;
    }

    public Class<?> getNBTContainerClass() {
        return this.nbtContainerClass;
    }

    public Function<Object, ?> getNBTContainerConstructor() {
        return this.nbtContainerConstructor;
    }

    public NMS<?> getCustomNMS() {
        return this.customNMS;
    }
}

