/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.IGreedyArgument;
import dev.jorel.commandapi.arguments.IPreviewable;
import dev.jorel.commandapi.arguments.PreviewInfo;
import dev.jorel.commandapi.exceptions.PaperAdventureNotFoundException;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.wrappers.PreviewableFunction;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdventureChatArgument
extends Argument<Component>
implements IGreedyArgument,
IPreviewable<AdventureChatArgument, Component> {
    private PreviewableFunction<Component> preview;
    private boolean usePreview;

    public AdventureChatArgument(String nodeName) {
        super(nodeName, CommandAPIHandler.getInstance().getNMS()._ArgumentChat());
        try {
            Class.forName("net.kyori.adventure.text.Component");
        }
        catch (ClassNotFoundException e) {
            throw new PaperAdventureNotFoundException(this.getClass());
        }
    }

    @Override
    public Class<Component> getPrimitiveType() {
        return Component.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.ADVENTURE_CHAT;
    }

    @Override
    public <CommandListenerWrapper> Component parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
        CommandSender sender = nms.getCommandSenderFromCSS(cmdCtx.getSource());
        Component component = nms.getAdventureChat(cmdCtx, key);
        if (this.usePreview && this.getPreview().isPresent() && sender instanceof Player) {
            Player player = (Player)sender;
            try {
                Component previewComponent;
                component = previewComponent = this.getPreview().get().generatePreview(new PreviewInfo<Component>(player, CommandAPIHandler.getRawArgumentInput(cmdCtx, key), cmdCtx.getInput(), component));
            }
            catch (WrapperCommandSyntaxException e) {
                throw e.getException();
            }
        }
        return component;
    }

    @Override
    public AdventureChatArgument withPreview(PreviewableFunction<Component> preview) {
        this.preview = preview;
        return this;
    }

    @Override
    public Optional<PreviewableFunction<Component>> getPreview() {
        return Optional.ofNullable(this.preview);
    }

    @Override
    public boolean isLegacy() {
        return false;
    }

    @Override
    public AdventureChatArgument usePreview(boolean usePreview) {
        this.usePreview = usePreview;
        return this;
    }
}

