/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.nms.NMS;
import org.bukkit.command.CommandSender;

public class CustomArgument<T, B>
extends Argument<T> {
    private final CustomArgumentInfoParser<T, B> infoParser;
    private final Argument<B> base;

    @Deprecated(forRemoval=true)
    public CustomArgument(String nodeName, CustomArgumentInfoParser<T, String> parser) {
        this(nodeName, parser, false);
    }

    @Deprecated(forRemoval=true)
    public CustomArgument(String nodeName, CustomArgumentInfoParser<T, String> parser, boolean keyed) {
        super(nodeName, keyed ? StringArgumentType.string() : CommandAPIHandler.getInstance().getNMS()._ArgumentMinecraftKeyRegistered());
        this.base = new DummyArgument(nodeName, keyed);
        this.infoParser = parser;
        CommandAPI.logWarning("Registering CustomArgument " + nodeName + " with legacy registeration method. This may not work!\nConsider using new CustomArgument(Argument, CustomArgumentInfoParser)");
    }

    public CustomArgument(Argument<B> base, CustomArgumentInfoParser<T, B> parser) {
        super(base.getNodeName(), base.getRawType());
        this.base = base;
        this.infoParser = parser;
    }

    @Override
    public Class<T> getPrimitiveType() {
        return null;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.CUSTOM;
    }

    @Override
    public <CommandListenerWrapper> T parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
        String customresult = CommandAPIHandler.getRawArgumentInput(cmdCtx, key);
        B parsedInput = this.base.parseArgument(nms, cmdCtx, key, previousArgs);
        try {
            return this.infoParser.apply(new CustomArgumentInfo<B>(nms.getCommandSenderFromCSS(cmdCtx.getSource()), previousArgs, customresult, parsedInput));
        }
        catch (CustomArgumentException e) {
            throw e.toCommandSyntax(customresult, cmdCtx);
        }
        catch (Exception e) {
            String errorMsg = new MessageBuilder("Error in executing command ").appendFullInput().append(" - ").appendArgInput().appendHere().toString().replace("%input%", customresult).replace("%finput%", cmdCtx.getInput());
            throw new SimpleCommandExceptionType(() -> errorMsg).create();
        }
    }

    @FunctionalInterface
    public static interface CustomArgumentInfoParser<T, B> {
        public T apply(CustomArgumentInfo<B> var1) throws CustomArgumentException;
    }

    @Deprecated
    private static class DummyArgument
    extends Argument<String> {
        private final boolean keyed;

        private DummyArgument(String nodeName, boolean keyed) {
            super(nodeName, keyed ? StringArgumentType.string() : CommandAPIHandler.getInstance().getNMS()._ArgumentMinecraftKeyRegistered());
            this.keyed = keyed;
        }

        @Override
        public Class<String> getPrimitiveType() {
            return String.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return this.keyed ? CommandAPIArgumentType.PRIMITIVE_STRING : CommandAPIArgumentType.NAMESPACED_KEY;
        }

        @Override
        public <CommandSourceStack> String parseArgument(NMS<CommandSourceStack> nms, CommandContext<CommandSourceStack> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
            return this.keyed ? nms.getMinecraftKey(cmdCtx, key).toString() : (String)cmdCtx.getArgument(key, String.class);
        }
    }

    public record CustomArgumentInfo<B>(CommandSender sender, Object[] previousArgs, String input, B currentInput) {
    }

    public static class CustomArgumentException
    extends Exception {
        private final String errorMessage;
        private final MessageBuilder errorMessageBuilder;

        public CustomArgumentException(String errorMessage) {
            this.errorMessage = errorMessage;
            this.errorMessageBuilder = null;
        }

        public CustomArgumentException(MessageBuilder errorMessage) {
            this.errorMessage = null;
            this.errorMessageBuilder = errorMessage;
        }

        public CommandSyntaxException toCommandSyntax(String result, CommandContext<?> cmdCtx) {
            if (this.errorMessage == null) {
                String errorMsg = this.errorMessageBuilder.toString().replace("%input%", result).replace("%finput%", cmdCtx.getInput());
                return new SimpleCommandExceptionType(() -> errorMsg).create();
            }
            return new SimpleCommandExceptionType((Message)new LiteralMessage(this.errorMessage)).create();
        }
    }

    public static class MessageBuilder {
        StringBuilder builder;

        public MessageBuilder() {
            this.builder = new StringBuilder();
        }

        public MessageBuilder(String str) {
            this.builder = new StringBuilder(str);
        }

        public MessageBuilder appendArgInput() {
            this.builder.append("%input%");
            return this;
        }

        public MessageBuilder appendFullInput() {
            this.builder.append("%finput%");
            return this;
        }

        public MessageBuilder appendHere() {
            this.builder.append("<--[HERE]");
            return this;
        }

        public MessageBuilder append(String str) {
            this.builder.append(str);
            return this;
        }

        public MessageBuilder append(Object obj) {
            this.builder.append(obj);
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

