/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIVersionHandler;
import dev.jorel.commandapi.CommandMetaData;
import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.CustomCommandExecutor;
import dev.jorel.commandapi.PaperImplementations;
import dev.jorel.commandapi.RegisteredCommand;
import dev.jorel.commandapi.SuggestionInfo;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.ICustomProvidedArgument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.nms.NMS;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.help.HelpTopic;
import org.bukkit.permissions.Permission;

public class CommandAPIHandler<CommandSourceStack> {
    private static final VarHandle COMMANDNODE_CHILDREN;
    private static final VarHandle COMMANDNODE_LITERALS;
    private static final VarHandle COMMANDNODE_ARGUMENTS;
    private static final VarHandle COMMANDCONTEXT_ARGUMENTS;
    private static CommandAPIHandler<?> instance;
    final Map<ClassCache, Field> FIELDS = new HashMap<ClassCache, Field>();
    final TreeMap<String, CommandPermission> PERMISSIONS_TO_FIX = new TreeMap();
    final NMS<CommandSourceStack> NMS;
    final CommandDispatcher<CommandSourceStack> DISPATCHER;
    final List<RegisteredCommand> registeredCommands;
    private PaperImplementations paper;

    public static <CommandSourceStack> String getRawArgumentInput(CommandContext<CommandSourceStack> cmdCtx, String key) {
        StringRange range = ((ParsedArgument)COMMANDCONTEXT_ARGUMENTS.get(cmdCtx).get(key)).getRange();
        return cmdCtx.getInput().substring(range.getStart(), range.getEnd());
    }

    public static CommandAPIHandler<?> getInstance() {
        if (instance == null) {
            instance = new CommandAPIHandler();
        }
        return instance;
    }

    private CommandAPIHandler() {
        String bukkit = Bukkit.getServer().toString();
        this.NMS = CommandAPIVersionHandler.getNMS(bukkit.substring(bukkit.indexOf("minecraftVersion") + 17, bukkit.length() - 1));
        this.DISPATCHER = this.NMS.getBrigadierDispatcher();
        this.registeredCommands = new ArrayList<RegisteredCommand>();
        this.paper = new PaperImplementations(false, this.NMS);
    }

    void checkDependencies() {
        block13: {
            block12: {
                block11: {
                    try {
                        Class.forName("com.mojang.brigadier.CommandDispatcher");
                    }
                    catch (ClassNotFoundException e) {
                        new ClassNotFoundException("Could not hook into Brigadier (Are you running Minecraft 1.13 or above?)").printStackTrace();
                    }
                    CommandAPI.logInfo("Hooked into NMS " + this.NMS.getClass().getName() + " (compatible with " + String.join((CharSequence)", ", this.NMS.compatibleVersions()) + ")");
                    Class<?> nbtContainerClass = CommandAPI.getConfiguration().getNBTContainerClass();
                    if (nbtContainerClass != null && CommandAPI.getConfiguration().getNBTContainerConstructor() != null) {
                        CommandAPI.logNormal("Hooked into an NBT API with class " + nbtContainerClass.getName());
                    } else if (CommandAPI.getConfiguration().hasVerboseOutput()) {
                        CommandAPI.logWarning("Could not hook into the NBT API for NBT support. Download it from https://www.spigotmc.org/resources/nbt-api.7939/");
                    }
                    try {
                        Class.forName("org.spigotmc.SpigotConfig");
                        CommandAPI.logNormal("Hooked into Spigot successfully for Chat/ChatComponents");
                    }
                    catch (ClassNotFoundException e) {
                        if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block11;
                        CommandAPI.logWarning("Could not hook into Spigot for Chat/ChatComponents");
                    }
                }
                try {
                    Class.forName("net.kyori.adventure.text.Component");
                    CommandAPI.logNormal("Hooked into Adventure for AdventureChat/AdventureChatComponents");
                }
                catch (ClassNotFoundException e) {
                    if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block12;
                    CommandAPI.logWarning("Could not hook into Adventure for AdventureChat/AdventureChatComponents");
                }
            }
            try {
                Class.forName("io.papermc.paper.event.server.ServerResourcesReloadedEvent");
                this.paper = new PaperImplementations(true, this.NMS);
                CommandAPI.logNormal("Hooked into Paper for paper-specific API implementations");
            }
            catch (ClassNotFoundException e) {
                if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block13;
                CommandAPI.logWarning("Could not hook into Paper for /minecraft:reload. Consider upgrading to Paper: https://papermc.io/");
            }
        }
    }

    public NMS<CommandSourceStack> getNMS() {
        return this.NMS;
    }

    public PaperImplementations getPaper() {
        return this.paper;
    }

    void unregister(String commandName, boolean force) {
        if (CommandAPI.getConfiguration().hasVerboseOutput()) {
            CommandAPI.logInfo("Unregistering command /" + commandName);
        }
        Map commandNodeChildren = COMMANDNODE_CHILDREN.get(this.DISPATCHER.getRoot());
        if (force) {
            for (String key : new HashSet(commandNodeChildren.keySet())) {
                if (!key.contains(":") || !key.split(":")[1].equalsIgnoreCase(commandName)) continue;
                commandNodeChildren.remove(key);
            }
        }
        commandNodeChildren.remove(commandName);
        COMMANDNODE_LITERALS.get(this.DISPATCHER.getRoot()).remove(commandName);
        COMMANDNODE_ARGUMENTS.get(this.DISPATCHER.getRoot()).remove(commandName);
    }

    Command<CommandSourceStack> generateCommand(Argument<?>[] args, CustomCommandExecutor<? extends CommandSender> executor, boolean converted) throws CommandSyntaxException {
        return cmdCtx -> {
            CommandSender sender = this.NMS.getSenderForCommand(cmdCtx, executor.isForceNative());
            if (converted) {
                Object[] argObjs = this.argsToObjectArr(cmdCtx, args);
                int resultValue = 0;
                String[] argsAndCmd = cmdCtx.getRange().get(cmdCtx.getInput()).split(" ");
                Object[] result = new String[argsAndCmd.length - 1];
                System.arraycopy(argsAndCmd, 1, result, 0, argsAndCmd.length - 1);
                ArrayList entityNamesForArgs = new ArrayList();
                for (int i = 0; i < args.length; ++i) {
                    entityNamesForArgs.set(i, args[i].getEntityNames(argObjs[i]));
                }
                List product = CartesianProduct.getDescartes(entityNamesForArgs);
                for (List strings : product) {
                    if (result.length == strings.size()) {
                        for (int i = 0; i < result.length; ++i) {
                            if (strings.get(i) == null) continue;
                            result[i] = (String)strings.get(i);
                        }
                    }
                    resultValue += executor.execute(sender, result);
                }
                return resultValue;
            }
            return executor.execute(sender, this.argsToObjectArr(cmdCtx, args));
        };
    }

    Object[] argsToObjectArr(CommandContext<CommandSourceStack> cmdCtx, Argument<?>[] args) throws CommandSyntaxException {
        ArrayList<Object> argList = new ArrayList<Object>();
        for (Argument<?> argument : args) {
            if (!argument.isListed()) continue;
            argList.add(this.parseArgument(cmdCtx, argument.getNodeName(), argument, args));
        }
        return argList.toArray();
    }

    Object parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, Argument<?> value, Argument<?>[] args) throws CommandSyntaxException {
        if (value.isListed()) {
            return value.parseArgument(this.NMS, cmdCtx, key, this.generatePreviousArguments(cmdCtx, args, key));
        }
        return null;
    }

    Predicate<CommandSourceStack> generatePermissions(String commandName, CommandPermission permission, Predicate<CommandSender> requirements) {
        CommandPermission finalPermission;
        if (this.PERMISSIONS_TO_FIX.containsKey(commandName.toLowerCase())) {
            if (!this.PERMISSIONS_TO_FIX.get(commandName.toLowerCase()).equals(permission)) {
                permission = this.PERMISSIONS_TO_FIX.get(commandName.toLowerCase());
            }
        } else {
            this.PERMISSIONS_TO_FIX.put(commandName.toLowerCase(), permission);
        }
        if ((finalPermission = permission).getPermission().isPresent()) {
            try {
                Bukkit.getPluginManager().addPermission(new Permission(finalPermission.getPermission().get()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return css -> this.permissionCheck(this.NMS.getCommandSenderFromCSS(css), finalPermission, requirements);
    }

    boolean permissionCheck(CommandSender sender, CommandPermission permission, Predicate<CommandSender> requirements) {
        boolean satisfiesPermissions = sender == null ? true : (permission.equals(CommandPermission.NONE) ? true : (permission.equals(CommandPermission.OP) ? sender.isOp() : sender.hasPermission(permission.getPermission().get())));
        if (permission.isNegated()) {
            satisfiesPermissions = !satisfiesPermissions;
        }
        return satisfiesPermissions && requirements.test(sender);
    }

    void fixPermissions() {
        CommandMap map = this.paper.getCommandMap();
        if (!this.PERMISSIONS_TO_FIX.isEmpty()) {
            CommandAPI.logInfo("Linking permissions to commands:");
        }
        for (Map.Entry<String, CommandPermission> entry : this.PERMISSIONS_TO_FIX.entrySet()) {
            String cmdName = entry.getKey();
            CommandPermission perm = entry.getValue();
            CommandAPI.logInfo(perm.toString() + " -> /" + cmdName);
            String permNode = perm.isNegated() || perm.equals(CommandPermission.NONE) || perm.equals(CommandPermission.OP) ? "" : (perm.getPermission().isPresent() ? perm.getPermission().get() : null);
            if (this.NMS.isVanillaCommandWrapper(map.getCommand(cmdName))) {
                map.getCommand(cmdName).setPermission(permNode);
            }
            if (!this.NMS.isVanillaCommandWrapper(map.getCommand("minecraft:" + cmdName))) continue;
            map.getCommand(cmdName).setPermission(permNode);
        }
        CommandAPI.logNormal("Linked " + this.PERMISSIONS_TO_FIX.size() + " Bukkit permissions to commands");
    }

    private boolean expandMultiLiterals(CommandMetaData meta, Argument<?>[] args, CustomCommandExecutor<? extends CommandSender> executor, boolean converted) throws CommandSyntaxException, IOException {
        for (int index = 0; index < args.length; ++index) {
            Argument<?> argument = args[index];
            if (!(argument instanceof MultiLiteralArgument)) continue;
            MultiLiteralArgument superArg = (MultiLiteralArgument)argument;
            for (int i = 0; i < superArg.getLiterals().length; ++i) {
                LiteralArgument litArg = (LiteralArgument)new LiteralArgument(superArg.getLiterals()[i]).setListed(superArg.isListed()).withPermission(superArg.getArgumentPermission()).withRequirement(superArg.getRequirements());
                Argument<?>[] newArgs = Arrays.copyOf(args, args.length);
                newArgs[index] = litArg;
                this.register(meta, newArgs, executor, converted);
            }
            return true;
        }
        return false;
    }

    private boolean hasCommandConflict(String commandName, Argument<?>[] args, String argumentsAsString) {
        ArrayList<String[]> regArgs = new ArrayList<String[]>();
        for (RegisteredCommand rCommand : this.registeredCommands) {
            if (!rCommand.commandName().equals(commandName)) continue;
            for (String str : rCommand.argsAsStr()) {
                regArgs.add(str.split(":"));
            }
        }
        for (int i = 0; i < args.length && (regArgs.size() != i || regArgs.size() >= args.length) && ((String[])regArgs.get(i))[0].equals(args[i].getNodeName()); ++i) {
            if (i != args.length - 1 || ((String[])regArgs.get(i))[1].equals(args[i].getClass().getSimpleName())) continue;
            StringBuilder builder2 = new StringBuilder();
            for (String[] arg : regArgs) {
                builder2.append(arg[0]).append("<").append(arg[1]).append("> ");
            }
            CommandAPI.logError("Failed to register command:\n\n  %s %s\n\nBecause it conflicts with this previously registered command:\n\n  %s %s\n".formatted(commandName, argumentsAsString, commandName, builder2.toString()));
            return true;
        }
        return false;
    }

    private ArgumentBuilder<CommandSourceStack, ?> generateInnerArgument(Command<CommandSourceStack> command, Argument<?>[] args) {
        Argument<?> innerArg = args[args.length - 1];
        if (innerArg instanceof LiteralArgument) {
            LiteralArgument literalArgument = (LiteralArgument)innerArg;
            return this.getLiteralArgumentBuilderArgument(literalArgument.getLiteral(), innerArg.getArgumentPermission(), innerArg.getRequirements()).executes(command);
        }
        if (innerArg instanceof ICustomProvidedArgument) {
            ICustomProvidedArgument customProvidedArg = (ICustomProvidedArgument)((Object)innerArg);
            if (!innerArg.getOverriddenSuggestions().isPresent()) {
                return this.getRequiredArgumentBuilderWithProvider(innerArg, args, this.NMS.getSuggestionProvider(customProvidedArg.getSuggestionProvider())).executes(command);
            }
        }
        return this.getRequiredArgumentBuilderDynamic(args, innerArg).executes(command);
    }

    private ArgumentBuilder<CommandSourceStack, ?> generateOuterArguments(ArgumentBuilder<CommandSourceStack, ?> innermostArgument, Argument<?>[] args) {
        ArgumentBuilder outer = innermostArgument;
        for (int i = args.length - 2; i >= 0; --i) {
            Argument<?> outerArg = args[i];
            if (outerArg instanceof LiteralArgument) {
                LiteralArgument literalArgument = (LiteralArgument)outerArg;
                outer = this.getLiteralArgumentBuilderArgument(literalArgument.getLiteral(), outerArg.getArgumentPermission(), outerArg.getRequirements()).then(outer);
                continue;
            }
            if (outerArg instanceof ICustomProvidedArgument) {
                ICustomProvidedArgument customProvidedArg = (ICustomProvidedArgument)((Object)outerArg);
                if (!outerArg.getOverriddenSuggestions().isPresent()) {
                    outer = this.getRequiredArgumentBuilderWithProvider(outerArg, args, this.NMS.getSuggestionProvider(customProvidedArg.getSuggestionProvider())).then(outer);
                    continue;
                }
            }
            outer = this.getRequiredArgumentBuilderDynamic(args, outerArg).then(outer);
        }
        return outer;
    }

    void register(CommandMetaData meta, Argument<?>[] args, CustomCommandExecutor<? extends CommandSender> executor, boolean converted) throws CommandSyntaxException, IOException {
        if (this.expandMultiLiterals(meta, args, executor, converted)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (Argument<?> arg : args) {
            builder.append(arg.getNodeName()).append("<").append(arg.getClass().getSimpleName()).append("> ");
        }
        String commandName = meta.commandName;
        CommandPermission permission = meta.permission;
        String[] aliases = meta.aliases;
        Predicate<CommandSender> requirements = meta.requirements;
        Optional<String> shortDescription = meta.shortDescription;
        Optional<String> fullDescription = meta.fullDescription;
        boolean hasRegisteredCommand = false;
        for (RegisteredCommand registeredCommand : this.registeredCommands) {
            hasRegisteredCommand |= registeredCommand.commandName().equals(commandName);
        }
        if (hasRegisteredCommand && this.hasCommandConflict(commandName, args, builder.toString())) {
            return;
        }
        ArrayList<String> argumentsString = new ArrayList<String>();
        for (Argument<?> arg : args) {
            argumentsString.add(arg.getNodeName() + ":" + arg.getClass().getSimpleName());
        }
        this.registeredCommands.add(new RegisteredCommand(commandName, argumentsString, shortDescription, fullDescription, aliases, permission));
        if (Bukkit.getPluginCommand((String)commandName) != null) {
            CommandAPI.logWarning("Plugin command /" + commandName + " is registered by Bukkit (" + Bukkit.getPluginCommand((String)commandName).getPlugin().getName() + "). Did you forget to remove this from your plugin.yml file?");
        }
        CommandAPI.logInfo("Registering command /" + commandName + " " + builder.toString());
        Command<CommandSourceStack> command = this.generateCommand(args, executor, converted);
        if (args.length == 0) {
            LiteralCommandNode literalCommandNode = this.DISPATCHER.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.getLiteralArgumentBuilder(commandName).requires(this.generatePermissions(commandName, permission, requirements))).executes(command));
            for (String alias : aliases) {
                CommandAPI.logInfo("Registering alias /" + alias + " -> " + literalCommandNode.getName());
                this.DISPATCHER.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.getLiteralArgumentBuilder(alias).requires(this.generatePermissions(alias, permission, requirements))).executes(command));
            }
        } else {
            ArgumentBuilder<CommandSourceStack, ?> commandArguments = this.generateOuterArguments(this.generateInnerArgument(command, args), args);
            LiteralCommandNode literalCommandNode = this.DISPATCHER.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.getLiteralArgumentBuilder(commandName).requires(this.generatePermissions(commandName, permission, requirements))).then(commandArguments));
            for (String alias : aliases) {
                if (CommandAPI.getConfiguration().hasVerboseOutput()) {
                    CommandAPI.logInfo("Registering alias /" + alias + " -> " + literalCommandNode.getName());
                }
                this.DISPATCHER.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.getLiteralArgumentBuilder(alias).requires(this.generatePermissions(alias, permission, requirements))).then(commandArguments));
            }
        }
        this.generateDispatcherFile();
    }

    private void generateDispatcherFile() throws IOException {
        if (CommandAPI.getConfiguration().getDispatcherFile() != null) {
            File file = CommandAPI.getConfiguration().getDispatcherFile();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
            this.NMS.createDispatcherFile(file, this.DISPATCHER);
        }
    }

    LiteralArgumentBuilder<CommandSourceStack> getLiteralArgumentBuilder(String commandName) {
        return LiteralArgumentBuilder.literal((String)commandName);
    }

    LiteralArgumentBuilder<CommandSourceStack> getLiteralArgumentBuilderArgument(String commandName, CommandPermission permission, Predicate<CommandSender> requirements) {
        LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)commandName);
        return (LiteralArgumentBuilder)builder.requires(css -> this.permissionCheck(this.NMS.getCommandSenderFromCSS(css), permission, requirements));
    }

    RequiredArgumentBuilder<CommandSourceStack, ?> getRequiredArgumentBuilderDynamic(Argument<?>[] args, Argument<?> argument) {
        if (argument.getOverriddenSuggestions().isPresent()) {
            return this.getRequiredArgumentBuilderWithProvider(argument, args, this.toSuggestions(argument.getNodeName(), args, true));
        }
        if (argument.getIncludedSuggestions().isPresent()) {
            return this.getRequiredArgumentBuilderWithProvider(argument, args, (cmdCtx, builder) -> argument.getRawType().listSuggestions(cmdCtx, builder));
        }
        return this.getRequiredArgumentBuilderWithProvider(argument, args, null);
    }

    RequiredArgumentBuilder<CommandSourceStack, ?> getRequiredArgumentBuilderWithProvider(Argument<?> argument, Argument<?>[] args, SuggestionProvider<CommandSourceStack> provider) {
        SuggestionProvider newSuggestionsProvider = provider;
        if (argument.getIncludedSuggestions().isPresent() && argument.getOverriddenSuggestions().isEmpty()) {
            SuggestionProvider addedSuggestions = this.toSuggestions(argument.getNodeName(), args, false);
            newSuggestionsProvider = (cmdCtx, builder) -> {
                CompletableFuture addedSuggestionsFuture = addedSuggestions.getSuggestions(cmdCtx, builder);
                CompletableFuture providerSuggestionsFuture = provider.getSuggestions(cmdCtx, builder);
                CompletableFuture result = new CompletableFuture();
                CompletableFuture.allOf(addedSuggestionsFuture, providerSuggestionsFuture).thenRun(() -> {
                    ArrayList<Suggestions> suggestions = new ArrayList<Suggestions>();
                    suggestions.add((Suggestions)addedSuggestionsFuture.join());
                    suggestions.add((Suggestions)providerSuggestionsFuture.join());
                    result.complete(Suggestions.merge((String)cmdCtx.getInput(), suggestions));
                });
                return result;
            };
        }
        RequiredArgumentBuilder requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)argument.getNodeName(), argument.getRawType());
        return ((RequiredArgumentBuilder)requiredArgumentBuilder.requires(css -> this.permissionCheck(this.NMS.getCommandSenderFromCSS(css), argument.getArgumentPermission(), argument.getRequirements()))).suggests(newSuggestionsProvider);
    }

    static Argument<?> getArgument(Argument<?>[] args, String nodeName) {
        for (Argument<?> arg : args) {
            if (!arg.getNodeName().equals(nodeName)) continue;
            return arg;
        }
        throw new NoSuchElementException("Could not find argument '" + nodeName + "'");
    }

    Object[] generatePreviousArguments(CommandContext<CommandSourceStack> context, Argument<?>[] args, String nodeName) throws CommandSyntaxException {
        ArrayList<Object> previousArguments = new ArrayList<Object>();
        for (Argument<?> arg : args) {
            Object result;
            if (arg.getNodeName().equals(nodeName)) break;
            try {
                result = this.parseArgument(context, arg.getNodeName(), arg, args);
            }
            catch (IllegalArgumentException e) {
                result = null;
            }
            if (!arg.isListed()) continue;
            previousArguments.add(result);
        }
        return previousArguments.toArray();
    }

    SuggestionProvider<CommandSourceStack> toSuggestions(String nodeName, Argument<?>[] args, boolean overrideSuggestions) {
        return (context, builder) -> {
            SuggestionInfo suggestionInfo = new SuggestionInfo(this.NMS.getCommandSenderFromCSS(context.getSource()), this.generatePreviousArguments(context, args, nodeName), builder.getInput(), builder.getRemaining());
            Optional<ArgumentSuggestions> suggestionsToAddOrOverride = overrideSuggestions ? CommandAPIHandler.getArgument(args, nodeName).getOverriddenSuggestions() : CommandAPIHandler.getArgument(args, nodeName).getIncludedSuggestions();
            return suggestionsToAddOrOverride.orElse(ArgumentSuggestions.empty()).suggest(suggestionInfo, builder);
        };
    }

    public Field getField(Class<?> clazz, String name) {
        ClassCache key = new ClassCache(clazz, name);
        if (this.FIELDS.containsKey(key)) {
            return this.FIELDS.get(key);
        }
        Field result = null;
        try {
            result = clazz.getDeclaredField(name);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        result.setAccessible(true);
        this.FIELDS.put(key, result);
        return result;
    }

    private String generateCommandHelpPrefix(String command) {
        return (Bukkit.getPluginCommand((String)command) == null ? "/" : "/minecraft:") + command;
    }

    private void generateHelpUsage(StringBuilder sb, RegisteredCommand command) {
        sb.append(ChatColor.GOLD + "Usage: " + ChatColor.WHITE);
        ArrayList<String> usages = new ArrayList<String>();
        for (RegisteredCommand rCommand : this.registeredCommands) {
            if (!rCommand.commandName().equals(command.commandName())) continue;
            StringBuilder usageString = new StringBuilder();
            usageString.append("/" + command.commandName() + " ");
            for (String arg : rCommand.argsAsStr()) {
                usageString.append("<" + arg.split(":")[0] + "> ");
            }
            usages.add(usageString.toString());
        }
        if (usages.size() == 1) {
            sb.append((String)usages.get(0));
        } else if (usages.size() > 1) {
            for (String usage : usages) {
                sb.append("\n- " + usage);
            }
        }
    }

    void updateHelpForCommands() {
        HashMap<String, HelpTopic> helpTopicsToAdd = new HashMap<String, HelpTopic>();
        for (RegisteredCommand command : this.registeredCommands) {
            String shortDescription = command.shortDescription().isPresent() ? command.shortDescription().get() : (command.fullDescription().isPresent() ? command.fullDescription().get() : "A Mojang provided command.");
            StringBuilder sb = new StringBuilder();
            if (command.fullDescription().isPresent()) {
                sb.append(ChatColor.GOLD + "Description: " + ChatColor.WHITE + command.fullDescription().get() + "\n");
            }
            this.generateHelpUsage(sb, command);
            sb.append("\n");
            StringBuilder aliasSb = new StringBuilder(sb.toString());
            if (command.aliases().length > 0) {
                sb.append(ChatColor.GOLD + "Aliases: " + ChatColor.WHITE + String.join((CharSequence)", ", command.aliases()));
            }
            String permission = command.permission().getPermission().orElseGet(() -> "");
            String commandPrefix = this.generateCommandHelpPrefix(command.commandName());
            helpTopicsToAdd.put(commandPrefix, this.NMS.generateHelpTopic(commandPrefix, shortDescription, sb.toString().trim(), permission));
            for (String alias : command.aliases()) {
                StringBuilder currentAliasSb = new StringBuilder(aliasSb.toString());
                if (command.aliases().length > 0) {
                    currentAliasSb.append(ChatColor.GOLD + "Aliases: " + ChatColor.WHITE);
                    ArrayList<String> aliases = new ArrayList<String>(Arrays.asList(command.aliases()));
                    aliases.add(command.commandName());
                    aliases.remove(alias);
                    currentAliasSb.append(ChatColor.WHITE + String.join((CharSequence)", ", aliases));
                }
                commandPrefix = this.generateCommandHelpPrefix(alias);
                helpTopicsToAdd.put(commandPrefix, this.NMS.generateHelpTopic(commandPrefix, shortDescription, currentAliasSb.toString().trim(), permission));
            }
        }
        this.NMS.addToHelpMap(helpTopicsToAdd);
    }

    static {
        VarHandle commandNodeChildren = null;
        VarHandle commandNodeLiterals = null;
        VarHandle commandNodeArguments = null;
        VarHandle commandContextArguments = null;
        try {
            commandNodeChildren = MethodHandles.privateLookupIn(CommandNode.class, MethodHandles.lookup()).findVarHandle(CommandNode.class, "children", Map.class);
            commandNodeLiterals = MethodHandles.privateLookupIn(CommandNode.class, MethodHandles.lookup()).findVarHandle(CommandNode.class, "literals", Map.class);
            commandNodeArguments = MethodHandles.privateLookupIn(CommandNode.class, MethodHandles.lookup()).findVarHandle(CommandNode.class, "arguments", Map.class);
            commandContextArguments = MethodHandles.privateLookupIn(CommandContext.class, MethodHandles.lookup()).findVarHandle(CommandContext.class, "arguments", Map.class);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        COMMANDNODE_CHILDREN = commandNodeChildren;
        COMMANDNODE_LITERALS = commandNodeLiterals;
        COMMANDNODE_ARGUMENTS = commandNodeArguments;
        COMMANDCONTEXT_ARGUMENTS = commandContextArguments;
    }

    private record ClassCache(Class<?> clazz, String name) {
    }

    private final class CartesianProduct {
        private CartesianProduct() {
        }

        public static final <T> List<List<T>> getDescartes(List<List<T>> list) {
            ArrayList<List<T>> returnList = new ArrayList<List<T>>();
            CartesianProduct.descartesRecursive(list, 0, returnList, new ArrayList());
            return returnList;
        }

        private static final <T> void descartesRecursive(List<List<T>> originalList, int position, List<List<T>> returnList, List<T> cacheList) {
            List<T> originalItemList = originalList.get(position);
            for (int i = 0; i < originalItemList.size(); ++i) {
                ArrayList<T> childCacheList = i == originalItemList.size() - 1 ? cacheList : new ArrayList<T>(cacheList);
                childCacheList.add(originalItemList.get(i));
                if (position == originalList.size() - 1) {
                    returnList.add(childCacheList);
                    continue;
                }
                CartesianProduct.descartesRecursive(originalList, position + 1, returnList, childCacheList);
            }
        }
    }
}

