/*******************************************************************************
 * Copyright 2018, 2020 Jorel Ali (Skepter) - MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *******************************************************************************/
package dev.jorel.commandapi.executors;

import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;

/**
 * The interface for resulting command executors
 * @param <CommandSender> The CommandSender for this executor
 * @param <WrapperType> The AbstractCommandSender that wraps the CommandSender
 */
public interface ResultingExecutor<CommandSender, WrapperType
/// @cond DOX
extends AbstractCommandSender<? extends CommandSender>
/// @endcond
> extends TypedExecutor<CommandSender, WrapperType> {

	/**
	 * Executes the command executor with the provided command sender and the provided arguments.
	 * @param info The ExecutionInfo for this command
	 * @return the value returned by this command if the command succeeds, 0 if the command fails
	 * @throws WrapperCommandSyntaxException if an error occurs during the execution of this command
	 */
	@Override
	default int executeWith(ExecutionInfo<CommandSender, WrapperType> info) throws WrapperCommandSyntaxException {
		return this.run(info);
	}

	/**
	 * Executes the command.
	 * @param info The ExecutionInfo for this command
	 * @return the value returned by this command
	 * @throws WrapperCommandSyntaxException if an error occurs during the execution of this command
	 */
	int run(ExecutionInfo<CommandSender, WrapperType> info) throws WrapperCommandSyntaxException;
}
