/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.executors;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class CommandArguments {
    private final Object[] args;
    private final Map<String, Object> argsMap;
    private final String fullInput;

    public CommandArguments(Object[] args, Map<String, Object> argsMap, String fullInput) {
        this.args = args;
        this.argsMap = argsMap;
        this.fullInput = fullInput;
    }

    public Object[] args() {
        return this.args;
    }

    public Map<String, Object> argsMap() {
        return Collections.unmodifiableMap(this.argsMap);
    }

    public int count() {
        return this.args.length;
    }

    @Nullable
    public Object get(int index) {
        if (this.args.length <= index) {
            return null;
        }
        return this.args[index];
    }

    @Nullable
    public Object get(String nodeName) {
        return this.argsMap.get(nodeName);
    }

    public String getFullInput() {
        return this.fullInput;
    }

    @Deprecated(since="9.0.1", forRemoval=true)
    public Object getOrDefault(int index, Object defaultValue) {
        if (this.args.length <= index) {
            return defaultValue;
        }
        return this.args[index];
    }

    @Deprecated(since="9.0.1", forRemoval=true)
    public Object getOrDefault(String nodeName, Object defaultValue) {
        return this.argsMap.getOrDefault(nodeName, defaultValue);
    }

    @Deprecated(since="9.0.1", forRemoval=true)
    public Object getOrDefault(int index, Supplier<?> defaultValue) {
        if (this.args.length <= index) {
            return defaultValue.get();
        }
        return this.args[index];
    }

    @Deprecated(since="9.0.1", forRemoval=true)
    public Object getOrDefault(String nodeName, Supplier<?> defaultValue) {
        return this.argsMap.getOrDefault(nodeName, defaultValue.get());
    }

    public Optional<Object> getOptional(int index) {
        if (this.args.length <= index) {
            return Optional.empty();
        }
        return Optional.of(this.args[index]);
    }

    public Optional<Object> getOptional(String nodeName) {
        if (!this.argsMap.containsKey(nodeName)) {
            return Optional.empty();
        }
        return Optional.of(this.argsMap.get(nodeName));
    }

    @Nullable
    public <T> T getUnchecked(int index) {
        return (T)this.get(index);
    }

    @Nullable
    public <T> T getUnchecked(String nodeName) {
        return (T)this.get(nodeName);
    }

    @Deprecated(since="9.0.1", forRemoval=true)
    public <T> T getOrDefaultUnchecked(int index, T defaultValue) {
        return (T)this.getOrDefault(index, defaultValue);
    }

    @Deprecated(since="9.0.1", forRemoval=true)
    public <T> T getOrDefaultUnchecked(String nodeName, T defaultValue) {
        return (T)this.getOrDefault(nodeName, defaultValue);
    }

    @Deprecated(since="9.0.1", forRemoval=true)
    public <T> T getOrDefaultUnchecked(int index, Supplier<T> defaultValue) {
        return (T)this.getOrDefault(index, defaultValue);
    }

    @Deprecated(since="9.0.1", forRemoval=true)
    public <T> T getOrDefaultUnchecked(String nodeName, Supplier<T> defaultValue) {
        return (T)this.getOrDefault(nodeName, defaultValue);
    }

    public <T> Optional<T> getOptionalUnchecked(int index) {
        return this.getOptional(index);
    }

    public <T> Optional<T> getOptionalUnchecked(String nodeName) {
        return this.getOptional(nodeName);
    }
}

