/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;

public interface CommandAPILogger {
    public static CommandAPILogger fromJavaLogger(java.util.logging.Logger logger) {
        return CommandAPILogger.bindToMethods(logger::info, logger::warning, logger::severe);
    }

    public static CommandAPILogger fromApacheLog4jLogger(Logger logger) {
        return CommandAPILogger.bindToMethods(arg_0 -> ((Logger)logger).info(arg_0), arg_0 -> ((Logger)logger).warn(arg_0), arg_0 -> ((Logger)logger).error(arg_0));
    }

    public static CommandAPILogger fromSlf4jLogger(org.slf4j.Logger logger) {
        return CommandAPILogger.bindToMethods(arg_0 -> ((org.slf4j.Logger)logger).info(arg_0), arg_0 -> ((org.slf4j.Logger)logger).warn(arg_0), arg_0 -> ((org.slf4j.Logger)logger).error(arg_0));
    }

    public static CommandAPILogger bindToMethods(final Consumer<String> info, final Consumer<String> warning, final Consumer<String> severe) {
        return new CommandAPILogger(){

            @Override
            public void info(String message) {
                info.accept(message);
            }

            @Override
            public void warning(String message) {
                warning.accept(message);
            }

            @Override
            public void severe(String message) {
                severe.accept(message);
            }
        };
    }

    public void info(String var1);

    public void warning(String var1);

    public void severe(String var1);
}

