/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.jorel.commandapi.CommandAPIConfig;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.InternalConfig;
import dev.jorel.commandapi.RegisteredCommand;
import dev.jorel.commandapi.Tooltip;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public final class CommandAPI {
    private static boolean canRegister;
    static InternalConfig config;
    static Logger logger;
    private static boolean loaded;

    private CommandAPI() {
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static InternalConfig getConfiguration() {
        if (config == null) {
            CommandAPI.onLoad(new CommandAPIConfig());
            CommandAPI.logWarning("Could not find any configuration for the CommandAPI. Loading basic built-in configuration. Did you forget to call CommandAPI.onLoad(config)?");
        }
        return config;
    }

    public static void onDisable() {
        canRegister = true;
        config = null;
        logger = null;
        loaded = false;
        CommandAPIHandler.onDisable();
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = new CommandAPILogger();
        }
        return logger;
    }

    public static void logInfo(String message) {
        if (config.hasVerboseOutput() && !config.hasSilentLogs()) {
            CommandAPI.getLogger().info(message);
        }
    }

    public static void logNormal(String message) {
        if (!config.hasSilentLogs()) {
            CommandAPI.getLogger().info(message);
        }
    }

    public static void logWarning(String message) {
        if (!config.hasSilentLogs()) {
            CommandAPI.getLogger().warning(message);
        }
    }

    public static void logError(String message) {
        CommandAPI.getLogger().severe(message);
    }

    public static void onLoad(CommandAPIConfig config) {
        if (!loaded) {
            CommandAPI.config = new InternalConfig(config);
            CommandAPIHandler.getInstance().checkDependencies();
            loaded = true;
        } else {
            CommandAPI.getLogger().severe("You've tried to call the CommandAPI's onLoad() method more than once!");
        }
    }

    public static void onEnable(final Plugin plugin) {
        Bukkit.getScheduler().runTaskLater(plugin, () -> {
            canRegister = false;
            CommandAPIHandler.getInstance().fixPermissions();
            CommandAPIHandler.getInstance().getNMS().reloadDataPacks();
            CommandAPIHandler.getInstance().updateHelpForCommands();
        }, 0L);
        Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler(priority=EventPriority.MONITOR)
            public void onPlayerJoin(PlayerJoinEvent e) {
                CommandAPIHandler.getInstance().getNMS().resendPackets(e.getPlayer());
            }
        }, plugin);
        if (CommandAPIHandler.getInstance().getNMS().canUseChatPreview()) {
            Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onPlayerJoin(PlayerJoinEvent e) {
                    if (Bukkit.shouldSendChatPreviews()) {
                        CommandAPIHandler.getInstance().getNMS().hookChatPreview(plugin, e.getPlayer());
                    }
                }

                @EventHandler
                public void onPlayerQuit(PlayerQuitEvent e) {
                    if (Bukkit.shouldSendChatPreviews()) {
                        CommandAPIHandler.getInstance().getNMS().unhookChatPreview(e.getPlayer());
                    }
                }
            }, plugin);
            CommandAPI.logNormal("Chat preview enabled");
        } else {
            CommandAPI.logNormal("Chat preview is not available");
        }
        CommandAPIHandler.getInstance().getPaper().registerReloadHandler(plugin);
    }

    public static void updateRequirements(Player player) {
        CommandAPIHandler.getInstance().getNMS().resendPackets(player);
    }

    public static void reloadDatapacks() {
        CommandAPIHandler.getInstance().getNMS().reloadDataPacks();
    }

    @Deprecated
    public static WrapperCommandSyntaxException fail(String message) {
        return CommandAPI.failWithString(message);
    }

    public static WrapperCommandSyntaxException failWithString(String message) {
        return CommandAPI.failWithMessage(Tooltip.messageFromString(message));
    }

    public static WrapperCommandSyntaxException failWithMessage(Message message) {
        return new WrapperCommandSyntaxException(new SimpleCommandExceptionType(message).create());
    }

    public static WrapperCommandSyntaxException failWithBaseComponents(BaseComponent ... message) {
        return CommandAPI.failWithMessage(Tooltip.messageFromBaseComponents(message));
    }

    public static WrapperCommandSyntaxException failWithAdventureComponent(Component message) {
        return CommandAPI.failWithMessage(Tooltip.messageFromAdventureComponent(message));
    }

    public static boolean canRegister() {
        return canRegister;
    }

    public static void unregister(String command) {
        CommandAPIHandler.getInstance().unregister(command, false);
    }

    public static void unregister(String command, boolean force) {
        if (!CommandAPI.canRegister()) {
            CommandAPI.getLogger().warning("Unexpected unregistering of /" + command + ", as server is loaded! Unregistering anyway, but this can lead to unstable results!");
        }
        CommandAPIHandler.getInstance().unregister(command, force);
    }

    public static void registerCommand(Class<?> commandClass) {
        try {
            Class.forName(commandClass.getName() + "$Command").getDeclaredMethod("register", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static List<RegisteredCommand> getRegisteredCommands() {
        return Collections.unmodifiableList(CommandAPIHandler.getInstance().registeredCommands);
    }

    static {
        CommandAPI.onDisable();
    }

    private static class CommandAPILogger
    extends Logger {
        protected CommandAPILogger() {
            super("CommandAPI", null);
            this.setParent(Bukkit.getServer().getLogger());
            this.setLevel(Level.ALL);
        }
    }
}

