/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.executors.CommandArguments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntitySelectorArgument {
    private EntitySelectorArgument() {
        throw new IllegalStateException("Use EntitySelectorArgument.OneEntity/OnePlayer/ManyEntities/ManyPlayers instead");
    }

    public static class ManyPlayers
    extends Argument<Collection> {
        public ManyPlayers(String nodeName) {
            super(nodeName, CommandAPIBukkit.get()._ArgumentEntity(ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS));
        }

        @Override
        public Class<Collection> getPrimitiveType() {
            return Collection.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.ENTITY_SELECTOR;
        }

        @Override
        public <CommandSourceStack> Collection<Player> parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
            return (Collection)CommandAPIBukkit.get().getEntitySelector(cmdCtx, key, ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS);
        }

        @Override
        public List<String> getEntityNames(Object argument) {
            ArrayList<String> playerNames = new ArrayList<String>();
            for (Player entity : (List)argument) {
                playerNames.add(entity.getName());
            }
            return playerNames;
        }
    }

    public static class ManyEntities
    extends Argument<Collection> {
        public ManyEntities(String nodeName) {
            super(nodeName, CommandAPIBukkit.get()._ArgumentEntity(ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES));
        }

        @Override
        public Class<Collection> getPrimitiveType() {
            return Collection.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.ENTITY_SELECTOR;
        }

        @Override
        public <CommandSourceStack> Collection<Entity> parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
            return (Collection)CommandAPIBukkit.get().getEntitySelector(cmdCtx, key, ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES);
        }

        @Override
        public List<String> getEntityNames(Object argument) {
            ArrayList<String> entityNames = new ArrayList<String>();
            for (Entity entity : (List)argument) {
                entityNames.add(entity.getName());
            }
            return entityNames;
        }
    }

    public static class OnePlayer
    extends Argument<Player> {
        public OnePlayer(String nodeName) {
            super(nodeName, CommandAPIBukkit.get()._ArgumentEntity(ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER));
        }

        @Override
        public Class<Player> getPrimitiveType() {
            return Player.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.ENTITY_SELECTOR;
        }

        @Override
        public <CommandSourceStack> Player parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
            return (Player)CommandAPIBukkit.get().getEntitySelector(cmdCtx, key, ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER);
        }

        @Override
        public List<String> getEntityNames(Object argument) {
            return List.of(((Player)argument).getName());
        }
    }

    public static class OneEntity
    extends Argument<Entity> {
        public OneEntity(String nodeName) {
            super(nodeName, CommandAPIBukkit.get()._ArgumentEntity(ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY));
        }

        @Override
        public Class<Entity> getPrimitiveType() {
            return Entity.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.ENTITY_SELECTOR;
        }

        @Override
        public <CommandSourceStack> Entity parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
            return (Entity)CommandAPIBukkit.get().getEntitySelector(cmdCtx, key, ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY);
        }

        @Override
        public List<String> getEntityNames(Object argument) {
            return List.of(((Entity)argument).getName());
        }
    }
}

