/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import dev.jorel.commandapi.BukkitTooltip;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkitConfig;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandAPIConfig;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandAPILogger;
import dev.jorel.commandapi.CommandAPIPlatform;
import dev.jorel.commandapi.CommandMetaData;
import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.InternalBukkitConfig;
import dev.jorel.commandapi.PaperImplementations;
import dev.jorel.commandapi.RegisteredCommand;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.Schedulers;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.AbstractPlayer;
import dev.jorel.commandapi.commandsenders.BukkitBlockCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitConsoleCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitEntity;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitPlayer;
import dev.jorel.commandapi.commandsenders.BukkitProxiedCommandSender;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.Recipe;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class CommandAPIBukkit<Source>
implements CommandAPIPlatform<Argument<?>, CommandSender, Source>,
NMS<Source> {
    private static CommandAPIBukkit<?> instance;
    private static InternalBukkitConfig config;
    private PaperImplementations paper;
    private static final SafeVarHandle<CommandNode<?>, Map> commandNodeChildren;
    private static final SafeVarHandle<CommandNode<?>, Map> commandNodeLiterals;
    private static final SafeVarHandle<CommandNode<?>, Map> commandNodeArguments;
    private static final SafeVarHandle<SimpleCommandMap, Map<String, Command>> commandMapKnownCommands;

    protected CommandAPIBukkit() {
        instance = this;
    }

    public static <Source> CommandAPIBukkit<Source> get() {
        if (instance != null) {
            return instance;
        }
        throw new IllegalStateException("Tried to access CommandAPIBukkit instance, but it was null! Are you using CommandAPI features before calling CommandAPI#onLoad?");
    }

    public PaperImplementations getPaper() {
        return this.paper;
    }

    public static InternalBukkitConfig getConfiguration() {
        if (config != null) {
            return config;
        }
        throw new IllegalStateException("Tried to access InternalBukkitConfig, but it was null! Did you load the CommandAPI properly with CommandAPI#onLoad?");
    }

    @Override
    public void onLoad(CommandAPIConfig<?> config) {
        if (config instanceof CommandAPIBukkitConfig) {
            CommandAPIBukkitConfig bukkitConfig = (CommandAPIBukkitConfig)config;
            CommandAPIBukkit.setInternalConfig(new InternalBukkitConfig(bukkitConfig));
        } else {
            CommandAPI.logError("CommandAPIBukkit was loaded with non-Bukkit config!");
            CommandAPI.logError("Attempts to access Bukkit-specific config variables will fail!");
        }
        this.checkDependencies();
    }

    private static void setInternalConfig(InternalBukkitConfig internalBukkitConfig) {
        config = internalBukkitConfig;
    }

    private void checkDependencies() {
        boolean isPaperPresent;
        block13: {
            block12: {
                block11: {
                    Class<?> nbtContainerClass = CommandAPI.getConfiguration().getNBTContainerClass();
                    if (nbtContainerClass != null && CommandAPI.getConfiguration().getNBTContainerConstructor() != null) {
                        CommandAPI.logNormal("Hooked into an NBT API with class " + nbtContainerClass.getName());
                    } else if (CommandAPI.getConfiguration().hasVerboseOutput()) {
                        CommandAPI.logWarning("Could not hook into the NBT API for NBT support. Download it from https://www.spigotmc.org/resources/nbt-api.7939/");
                    }
                    try {
                        Class.forName("org.spigotmc.SpigotConfig");
                        CommandAPI.logNormal("Hooked into Spigot successfully for Chat/ChatComponents");
                    }
                    catch (ClassNotFoundException e) {
                        if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block11;
                        CommandAPI.logWarning("Could not hook into Spigot for Chat/ChatComponents");
                    }
                }
                try {
                    Class.forName("net.kyori.adventure.text.Component");
                    CommandAPI.logNormal("Hooked into Adventure for AdventureChat/AdventureChatComponents");
                }
                catch (ClassNotFoundException e) {
                    if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block12;
                    CommandAPI.logWarning("Could not hook into Adventure for AdventureChat/AdventureChatComponents");
                }
            }
            isPaperPresent = false;
            try {
                Class.forName("io.papermc.paper.event.server.ServerResourcesReloadedEvent");
                isPaperPresent = true;
                CommandAPI.logNormal("Hooked into Paper for paper-specific API implementations");
            }
            catch (ClassNotFoundException e) {
                isPaperPresent = false;
                if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block13;
                CommandAPI.logWarning("Could not hook into Paper for /minecraft:reload. Consider upgrading to Paper: https://papermc.io/");
            }
        }
        boolean isFoliaPresent = false;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServerInitEvent");
            isFoliaPresent = true;
            CommandAPI.logNormal("Hooked into Folia for folia-specific API implementations");
            CommandAPI.logNormal("Folia support is still in development. Please report any issues to the CommandAPI developers!");
        }
        catch (ClassNotFoundException e) {
            isFoliaPresent = false;
        }
        this.paper = new PaperImplementations(isPaperPresent, isFoliaPresent, this);
    }

    @Override
    public void onEnable() {
        JavaPlugin plugin = config.getPlugin();
        new Schedulers(this.paper).scheduleSyncDelayed((Plugin)plugin, () -> {
            CommandAPI.stopCommandRegistration();
            this.fixPermissions();
            if (this.paper.isFoliaPresent()) {
                CommandAPI.logNormal("Skipping initial datapack reloading because Folia was detected");
            } else {
                this.reloadDataPacks();
            }
            this.updateHelpForCommands(CommandAPI.getRegisteredCommands());
        }, 0L);
        this.paper.registerReloadHandler((Plugin)plugin);
    }

    private void fixPermissions() {
        CommandMap map = this.paper.getCommandMap();
        TreeMap<String, CommandPermission> permissionsToFix = CommandAPIHandler.getInstance().registeredPermissions;
        if (!permissionsToFix.isEmpty()) {
            CommandAPI.logInfo("Linking permissions to commands:");
            for (Map.Entry entry : permissionsToFix.entrySet()) {
                String cmdName = (String)entry.getKey();
                CommandPermission perm = (CommandPermission)entry.getValue();
                CommandAPI.logInfo("  " + perm.toString() + " -> /" + cmdName);
                String permNode = this.unpackInternalPermissionNodeString(perm);
                for (Command command : new Command[]{map.getCommand(cmdName), map.getCommand("minecraft:" + cmdName)}) {
                    if (command == null || !this.isVanillaCommandWrapper(command)) continue;
                    command.setPermission(permNode);
                }
            }
        }
        CommandAPI.logNormal("Linked " + permissionsToFix.size() + " Bukkit permissions to commands");
    }

    private String unpackInternalPermissionNodeString(CommandPermission perm) {
        Optional<String> optionalPerm = perm.getPermission();
        if (perm.isNegated() || perm.equals(CommandPermission.NONE) || perm.equals(CommandPermission.OP)) {
            return "";
        }
        if (optionalPerm.isPresent()) {
            return optionalPerm.get();
        }
        throw new IllegalStateException("Invalid permission detected: " + perm + "! This should never happen - if you're seeing this message, pleasecontact the developers of the CommandAPI, we'd love to know how you managed to get this error!");
    }

    private String generateCommandHelpPrefix(String command) {
        return (Bukkit.getPluginCommand((String)command) == null ? "/" : "/minecraft:") + command;
    }

    private void generateHelpUsage(StringBuilder sb, RegisteredCommand command) {
        String[] usages = this.getUsageList(command);
        if (usages.length == 0) {
            return;
        }
        sb.append(ChatColor.GOLD).append("Usage: ").append(ChatColor.WHITE);
        if (usages.length == 1) {
            sb.append(usages[0]);
        } else {
            for (String usage : usages) {
                sb.append("\n- ").append(usage);
            }
        }
    }

    private String[] getUsageList(RegisteredCommand currentCommand) {
        String[] usages;
        ArrayList<RegisteredCommand> commandsWithIdenticalNames = new ArrayList<RegisteredCommand>();
        for (RegisteredCommand registeredCommand : CommandAPIHandler.getInstance().registeredCommands) {
            if (!registeredCommand.commandName().equals(currentCommand.commandName())) continue;
            commandsWithIdenticalNames.add(registeredCommand);
        }
        Optional<String[]> usageDescription = currentCommand.usageDescription();
        if (usageDescription.isPresent()) {
            usages = usageDescription.get();
        } else {
            int numCommandsWithIdenticalNames = commandsWithIdenticalNames.size();
            usages = new String[numCommandsWithIdenticalNames];
            for (int i = 0; i < numCommandsWithIdenticalNames; ++i) {
                RegisteredCommand command = (RegisteredCommand)commandsWithIdenticalNames.get(i);
                StringBuilder usageString = new StringBuilder();
                usageString.append("/").append(command.commandName()).append(" ");
                for (String arg : command.argsAsStr()) {
                    usageString.append("<").append(arg.split(":")[0]).append("> ");
                }
                usages[i] = usageString.toString().trim();
            }
        }
        return usages;
    }

    void updateHelpForCommands(List<RegisteredCommand> commands) {
        HashMap<String, HelpTopic> helpTopicsToAdd = new HashMap<String, HelpTopic>();
        for (RegisteredCommand command : commands) {
            Optional<String> shortDescriptionOptional = command.shortDescription();
            Optional<String> fullDescriptionOptional = command.fullDescription();
            Object shortDescription = shortDescriptionOptional.isPresent() ? shortDescriptionOptional.get() : (fullDescriptionOptional.isPresent() ? fullDescriptionOptional.get() : "A command by the " + config.getPlugin().getName() + " plugin.");
            StringBuilder sb = new StringBuilder();
            if (fullDescriptionOptional.isPresent()) {
                sb.append(ChatColor.GOLD).append("Description: ").append(ChatColor.WHITE).append(fullDescriptionOptional.get()).append("\n");
            }
            this.generateHelpUsage(sb, command);
            sb.append("\n");
            StringBuilder aliasSb = new StringBuilder(sb.toString());
            if (command.aliases().length > 0) {
                sb.append(ChatColor.GOLD).append("Aliases: ").append(ChatColor.WHITE).append(String.join((CharSequence)", ", command.aliases()));
            }
            String permission = command.permission().getPermission().orElse("");
            String commandPrefix = this.generateCommandHelpPrefix(command.commandName());
            helpTopicsToAdd.put(commandPrefix, this.generateHelpTopic(commandPrefix, (String)shortDescription, sb.toString().trim(), permission));
            for (String alias : command.aliases()) {
                StringBuilder currentAliasSb = new StringBuilder(aliasSb.toString());
                currentAliasSb.append(ChatColor.GOLD).append("Aliases: ").append(ChatColor.WHITE);
                ArrayList<String> aliases = new ArrayList<String>(Arrays.asList(command.aliases()));
                aliases.add(command.commandName());
                aliases.remove(alias);
                currentAliasSb.append(ChatColor.WHITE).append(String.join((CharSequence)", ", aliases));
                commandPrefix = this.generateCommandHelpPrefix(alias);
                helpTopicsToAdd.put(commandPrefix, this.generateHelpTopic(commandPrefix, (String)shortDescription, currentAliasSb.toString().trim(), permission));
            }
        }
        this.getHelpMap().putAll(helpTopicsToAdd);
    }

    @Override
    public void onDisable() {
    }

    @Override
    public abstract BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<Source> var1, boolean var2);

    @Override
    public abstract BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(Source var1);

    @Override
    public abstract Source getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> var1);

    @Override
    public BukkitCommandSender<? extends CommandSender> wrapCommandSender(CommandSender sender) {
        if (sender instanceof BlockCommandSender) {
            BlockCommandSender block = (BlockCommandSender)sender;
            return new BukkitBlockCommandSender(block);
        }
        if (sender instanceof ConsoleCommandSender) {
            ConsoleCommandSender console = (ConsoleCommandSender)sender;
            return new BukkitConsoleCommandSender(console);
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return new BukkitPlayer(player);
        }
        if (sender instanceof Entity) {
            Entity entity = (Entity)sender;
            return new BukkitEntity(entity);
        }
        if (sender instanceof NativeProxyCommandSender) {
            NativeProxyCommandSender nativeProxy = (NativeProxyCommandSender)sender;
            return new BukkitNativeProxyCommandSender(nativeProxy);
        }
        if (sender instanceof ProxiedCommandSender) {
            ProxiedCommandSender proxy = (ProxiedCommandSender)sender;
            return new BukkitProxiedCommandSender(proxy);
        }
        return null;
    }

    @Override
    public void registerPermission(String string) {
        try {
            Bukkit.getPluginManager().addPermission(new Permission(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public abstract SuggestionProvider<Source> getSuggestionProvider(SuggestionProviders var1);

    @Override
    public void preCommandRegistration(String commandName) {
        PluginCommand pluginCommand = Bukkit.getPluginCommand((String)commandName);
        if (pluginCommand == null) {
            return;
        }
        String pluginName = pluginCommand.getPlugin().getName();
        if (config.getPlugin().getName().equals(pluginName)) {
            CommandAPI.logWarning("Plugin command /%s is registered by Bukkit (%s). Did you forget to remove this from your plugin.yml file?".formatted(commandName, pluginName));
        } else {
            CommandAPI.logNormal("Plugin command /%s is registered by Bukkit (%s). You may have to use /minecraft:%s to execute your command.".formatted(commandName, pluginName, commandName));
        }
    }

    @Override
    public void postCommandRegistration(RegisteredCommand registeredCommand, LiteralCommandNode<Source> resultantNode, List<LiteralCommandNode<Source>> aliasNodes) {
        if (!CommandAPI.canRegister()) {
            CommandMap map = this.paper.getCommandMap();
            String permNode = this.unpackInternalPermissionNodeString(registeredCommand.permission());
            RootCommandNode root = this.getResourcesDispatcher().getRoot();
            Command command = this.wrapToVanillaCommandWrapper(resultantNode);
            map.register("minecraft", command);
            command.setPermission(permNode);
            root.addChild(resultantNode);
            root.addChild(this.namespaceNode(resultantNode));
            for (LiteralCommandNode<Source> node : aliasNodes) {
                command = this.wrapToVanillaCommandWrapper(node);
                map.register("minecraft", command);
                command.setPermission(permNode);
                root.addChild(node);
                root.addChild(this.namespaceNode(node));
            }
            this.updateHelpForCommands(List.of(registeredCommand));
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.updateCommands();
            }
        }
    }

    private LiteralCommandNode<Source> namespaceNode(LiteralCommandNode<Source> original) {
        LiteralCommandNode clone = new LiteralCommandNode("minecraft:" + original.getLiteral(), original.getCommand(), original.getRequirement(), original.getRedirect(), original.getRedirectModifier(), original.isFork());
        for (CommandNode child : original.getChildren()) {
            clone.addChild(child);
        }
        return clone;
    }

    @Override
    public LiteralCommandNode<Source> registerCommandNode(LiteralArgumentBuilder<Source> node) {
        return this.getBrigadierDispatcher().register(node);
    }

    @Override
    public void unregister(String commandName, boolean unregisterNamespaces) {
        this.unregisterInternal(commandName, unregisterNamespaces, false);
    }

    public static void unregister(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
        CommandAPIBukkit.get().unregisterInternal(commandName, unregisterNamespaces, unregisterBukkit);
    }

    private void unregisterInternal(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
        CommandAPI.logInfo("Unregistering command /" + commandName);
        if (!unregisterBukkit) {
            this.removeBrigadierCommands(this.getBrigadierDispatcher(), commandName, unregisterNamespaces, c -> true);
            CommandAPIHandler.getInstance().writeDispatcherToFile();
        }
        if (unregisterBukkit || !CommandAPI.canRegister()) {
            Map<String, Command> knownCommands = commandMapKnownCommands.get((SimpleCommandMap)this.paper.getCommandMap());
            boolean isMainVanilla = this.isVanillaCommandWrapper(knownCommands.get(commandName));
            if (unregisterBukkit ^ isMainVanilla) {
                knownCommands.remove(commandName);
            }
            if (unregisterNamespaces) {
                CommandAPIBukkit.removeCommandNamespace(knownCommands, commandName, c -> unregisterBukkit ^ this.isVanillaCommandWrapper((Command)c));
            }
        }
        if (!CommandAPI.canRegister()) {
            this.removeBrigadierCommands(this.getResourcesDispatcher(), commandName, unregisterNamespaces, c -> !unregisterBukkit ^ this.isBukkitCommandWrapper(c));
            this.getHelpMap().remove("/" + commandName);
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.updateCommands();
            }
        }
    }

    private void removeBrigadierCommands(CommandDispatcher<Source> dispatcher, String commandName, boolean unregisterNamespaces, Predicate<CommandNode<Source>> extraCheck) {
        RootCommandNode root = dispatcher.getRoot();
        Map children = commandNodeChildren.get((CommandNode<?>)root);
        Map literals = commandNodeLiterals.get((CommandNode<?>)root);
        Map arguments = commandNodeArguments.get((CommandNode<?>)root);
        CommandAPIBukkit.removeCommandFromMapIfCheckPasses(children, commandName, extraCheck);
        CommandAPIBukkit.removeCommandFromMapIfCheckPasses(literals, commandName, extraCheck);
        CommandAPIBukkit.removeCommandFromMapIfCheckPasses(arguments, commandName, extraCheck);
        if (unregisterNamespaces) {
            CommandAPIBukkit.removeCommandNamespace(children, commandName, extraCheck);
            CommandAPIBukkit.removeCommandNamespace(literals, commandName, extraCheck);
            CommandAPIBukkit.removeCommandNamespace(arguments, commandName, extraCheck);
        }
    }

    private static <T> void removeCommandNamespace(Map<String, T> map, String commandName, Predicate<T> extraCheck) {
        for (String key : new HashSet<String>(map.keySet())) {
            if (!CommandAPIBukkit.isThisTheCommandButNamespaced(commandName, key)) continue;
            CommandAPIBukkit.removeCommandFromMapIfCheckPasses(map, key, extraCheck);
        }
    }

    private static <T> void removeCommandFromMapIfCheckPasses(Map<String, T> map, String key, Predicate<T> extraCheck) {
        T element = map.get(key);
        if (element == null) {
            return;
        }
        if (extraCheck.test(map.get(key))) {
            map.remove(key);
        }
    }

    private static boolean isThisTheCommandButNamespaced(String commandName, String key) {
        return key.contains(":") && key.split(":")[1].equalsIgnoreCase(commandName);
    }

    @Override
    public abstract CommandDispatcher<Source> getBrigadierDispatcher();

    @Override
    public abstract void createDispatcherFile(File var1, CommandDispatcher<Source> var2) throws IOException;

    public abstract <T> T getMinecraftServer();

    @Override
    public CommandAPILogger getLogger() {
        return new DefaultLogger();
    }

    @Override
    public abstract void reloadDataPacks();

    @Override
    public void updateRequirements(AbstractPlayer<?> player) {
        ((Player)player.getSource()).updateCommands();
    }

    @Override
    public Argument<String> newConcreteMultiLiteralArgument(String nodeName, String[] literals) {
        return new MultiLiteralArgument(nodeName, literals);
    }

    @Override
    public Argument<String> newConcreteLiteralArgument(String nodeName, String literal) {
        return new LiteralArgument(nodeName, literal);
    }

    public CommandAPICommand newConcreteCommandAPICommand(CommandMetaData<CommandSender> meta) {
        return new CommandAPICommand(meta);
    }

    public static WrapperCommandSyntaxException failWithBaseComponents(BaseComponent ... message) {
        return CommandAPI.failWithMessage(BukkitTooltip.messageFromBaseComponents(message));
    }

    public static WrapperCommandSyntaxException failWithAdventureComponent(Component message) {
        return CommandAPI.failWithMessage(BukkitTooltip.messageFromAdventureComponent(message));
    }

    protected void registerBukkitRecipesSafely(Iterator<Recipe> recipes) {
        while (recipes.hasNext()) {
            Recipe recipe = recipes.next();
            try {
                Bukkit.addRecipe((Recipe)recipe);
                if (!(recipe instanceof Keyed)) continue;
                Keyed keyedRecipe = (Keyed)recipe;
                CommandAPI.logInfo("Re-registering recipe: " + keyedRecipe.getKey());
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    static {
        commandNodeChildren = SafeVarHandle.ofOrNull(CommandNode.class, "children", "children", Map.class);
        commandNodeLiterals = SafeVarHandle.ofOrNull(CommandNode.class, "literals", "literals", Map.class);
        commandNodeArguments = SafeVarHandle.ofOrNull(CommandNode.class, "arguments", "arguments", Map.class);
        commandMapKnownCommands = SafeVarHandle.ofOrNull(SimpleCommandMap.class, "knownCommands", "knownCommands", Map.class);
    }

    private static class DefaultLogger
    extends Logger
    implements CommandAPILogger {
        protected DefaultLogger() {
            super("CommandAPI", null);
            this.setParent(Bukkit.getServer().getLogger());
            this.setLevel(Level.ALL);
        }

        @Override
        public void severe(String message, Throwable exception) {
            super.log(Level.SEVERE, message, exception);
        }
    }
}

