/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.SafeOverrideableArgument;
import dev.jorel.commandapi.exceptions.InvalidRangeException;
import dev.jorel.commandapi.executors.CommandArguments;

public class DoubleArgument
extends SafeOverrideableArgument<Double, Double> {
    public DoubleArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)DoubleArgumentType.doubleArg(), String::valueOf);
    }

    public DoubleArgument(String nodeName, double min) {
        super(nodeName, (ArgumentType<?>)DoubleArgumentType.doubleArg((double)min), String::valueOf);
    }

    public DoubleArgument(String nodeName, double min, double max) {
        super(nodeName, (ArgumentType<?>)DoubleArgumentType.doubleArg((double)min, (double)max), String::valueOf);
        if (max < min) {
            throw new InvalidRangeException();
        }
    }

    public Class<Double> getPrimitiveType() {
        return Double.TYPE;
    }

    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_DOUBLE;
    }

    public <Source> Double parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return (Double)cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

