/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.jorel.commandapi.BukkitTooltip;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkitConfig;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandAPIConfig;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandAPILogger;
import dev.jorel.commandapi.CommandAPIPlatform;
import dev.jorel.commandapi.CommandMetaData;
import dev.jorel.commandapi.CommandRegistrationStrategy;
import dev.jorel.commandapi.InternalBukkitConfig;
import dev.jorel.commandapi.PaperImplementations;
import dev.jorel.commandapi.RegisteredCommand;
import dev.jorel.commandapi.Schedulers;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.AbstractPlayer;
import dev.jorel.commandapi.commandsenders.BukkitBlockCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitConsoleCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitEntity;
import dev.jorel.commandapi.commandsenders.BukkitFeedbackForwardingCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitPlayer;
import dev.jorel.commandapi.commandsenders.BukkitProxiedCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitRemoteConsoleCommandSender;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.Recipe;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class CommandAPIBukkit<Source>
implements CommandAPIPlatform<Argument<?>, CommandSender, Source>,
NMS<Source> {
    private static CommandAPIBukkit<?> instance;
    private static InternalBukkitConfig config;
    private PaperImplementations paper;
    private CommandRegistrationStrategy<Source> commandRegistrationStrategy;

    protected CommandAPIBukkit() {
        instance = this;
    }

    public static <Source> CommandAPIBukkit<Source> get() {
        if (instance != null) {
            return instance;
        }
        throw new IllegalStateException("Tried to access CommandAPIBukkit instance, but it was null! Are you using CommandAPI features before calling CommandAPI#onLoad?");
    }

    public PaperImplementations getPaper() {
        return this.paper;
    }

    public static InternalBukkitConfig getConfiguration() {
        if (config != null) {
            return config;
        }
        throw new IllegalStateException("Tried to access InternalBukkitConfig, but it was null! Did you load the CommandAPI properly with CommandAPI#onLoad?");
    }

    public CommandRegistrationStrategy<Source> getCommandRegistrationStrategy() {
        return this.commandRegistrationStrategy;
    }

    public void onLoad(CommandAPIConfig<?> config) {
        if (config instanceof CommandAPIBukkitConfig) {
            CommandAPIBukkitConfig bukkitConfig = (CommandAPIBukkitConfig)config;
            CommandAPIBukkit.setInternalConfig(new InternalBukkitConfig(bukkitConfig));
        } else {
            CommandAPI.logError((String)"CommandAPIBukkit was loaded with non-Bukkit config!");
            CommandAPI.logError((String)"Attempts to access Bukkit-specific config variables will fail!");
        }
        this.checkDependencies();
    }

    private static void setInternalConfig(InternalBukkitConfig internalBukkitConfig) {
        config = internalBukkitConfig;
    }

    private void checkDependencies() {
        boolean isPaperPresent;
        block11: {
            block10: {
                block9: {
                    Class nbtContainerClass = CommandAPI.getConfiguration().getNBTContainerClass();
                    if (nbtContainerClass != null && CommandAPI.getConfiguration().getNBTContainerConstructor() != null) {
                        CommandAPI.logNormal((String)("Hooked into an NBT API with class " + nbtContainerClass.getName()));
                    }
                    try {
                        Class.forName("org.spigotmc.SpigotConfig");
                        CommandAPI.logNormal((String)"Hooked into Spigot successfully for Chat/ChatComponents");
                    }
                    catch (ClassNotFoundException e) {
                        if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block9;
                        CommandAPI.logWarning((String)"Could not hook into Spigot for Chat/ChatComponents");
                    }
                }
                try {
                    Class.forName("net.kyori.adventure.text.Component");
                    CommandAPI.logNormal((String)"Hooked into Adventure for AdventureChat/AdventureChatComponents");
                }
                catch (ClassNotFoundException e) {
                    if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block10;
                    CommandAPI.logWarning((String)"Could not hook into Adventure for AdventureChat/AdventureChatComponents");
                }
            }
            isPaperPresent = false;
            try {
                Class.forName("io.papermc.paper.event.server.ServerResourcesReloadedEvent");
                isPaperPresent = true;
                CommandAPI.logNormal((String)"Hooked into Paper for paper-specific API implementations");
            }
            catch (ClassNotFoundException e) {
                isPaperPresent = false;
                if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block11;
                CommandAPI.logWarning((String)"Could not hook into Paper for /minecraft:reload. Consider upgrading to Paper: https://papermc.io/");
            }
        }
        boolean isFoliaPresent = false;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServerInitEvent");
            isFoliaPresent = true;
            CommandAPI.logNormal((String)"Hooked into Folia for folia-specific API implementations");
            CommandAPI.logNormal((String)"Folia support is still in development. Please report any issues to the CommandAPI developers!");
        }
        catch (ClassNotFoundException e) {
            isFoliaPresent = false;
        }
        this.paper = new PaperImplementations(isPaperPresent, isFoliaPresent, this);
        this.commandRegistrationStrategy = this.createCommandRegistrationStrategy();
    }

    public void onEnable() {
        JavaPlugin plugin = config.getPlugin();
        new Schedulers(this.paper).scheduleSyncDelayed((Plugin)plugin, () -> {
            this.commandRegistrationStrategy.runTasksAfterServerStart();
            if (this.paper.isFoliaPresent()) {
                CommandAPI.logNormal((String)"Skipping initial datapack reloading because Folia was detected");
            } else if (!CommandAPIBukkit.getConfiguration().skipReloadDatapacks()) {
                this.reloadDataPacks();
            }
            this.updateHelpForCommands(CommandAPI.getRegisteredCommands());
        }, 0L);
        Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler(priority=EventPriority.LOWEST)
            public void onServerLoad(ServerLoadEvent event) {
                CommandAPI.stopCommandRegistration();
            }
        }, (Plugin)CommandAPIBukkit.getConfiguration().getPlugin());
        this.paper.registerReloadHandler((Plugin)plugin);
    }

    private String generateCommandHelpPrefix(String command) {
        return (Bukkit.getPluginCommand((String)command) == null ? "/" : "/minecraft:") + command;
    }

    private String generateCommandHelpPrefix(String command, String namespace) {
        return (String)(Bukkit.getPluginCommand((String)command) == null ? "/" + namespace + ":" : "/minecraft:") + command;
    }

    private void generateHelpUsage(StringBuilder sb, RegisteredCommand command) {
        String[] usages = this.getUsageList(command);
        if (usages.length == 0) {
            return;
        }
        sb.append(ChatColor.GOLD).append("Usage: ").append(ChatColor.WHITE);
        if (usages.length == 1) {
            sb.append(usages[0]);
        } else {
            for (String usage : usages) {
                sb.append("\n- ").append(usage);
            }
        }
    }

    private String[] getUsageList(RegisteredCommand currentCommand) {
        String[] usages;
        ArrayList<RegisteredCommand> commandsWithIdenticalNames = new ArrayList<RegisteredCommand>();
        for (RegisteredCommand registeredCommand : CommandAPIHandler.getInstance().registeredCommands) {
            if (!registeredCommand.commandName().equals(currentCommand.commandName())) continue;
            commandsWithIdenticalNames.add(registeredCommand);
        }
        Optional usageDescription = currentCommand.usageDescription();
        if (usageDescription.isPresent()) {
            usages = (String[])usageDescription.get();
        } else {
            int numCommandsWithIdenticalNames = commandsWithIdenticalNames.size();
            usages = new String[numCommandsWithIdenticalNames];
            for (int i = 0; i < numCommandsWithIdenticalNames; ++i) {
                RegisteredCommand command = (RegisteredCommand)commandsWithIdenticalNames.get(i);
                StringBuilder usageString = new StringBuilder();
                usageString.append("/").append(command.commandName()).append(" ");
                for (AbstractArgument arg : command.arguments()) {
                    usageString.append(arg.getHelpString()).append(" ");
                }
                usages[i] = usageString.toString().trim();
            }
        }
        return usages;
    }

    void updateHelpForCommands(List<RegisteredCommand> commands) {
        HashMap<String, HelpTopic> helpTopicsToAdd = new HashMap<String, HelpTopic>();
        HashSet<String> namespacedCommandNames = new HashSet<String>();
        for (RegisteredCommand command : commands) {
            Object shortDescription;
            HelpTopic helpTopic;
            String commandPrefix = this.generateCommandHelpPrefix(command.commandName());
            namespacedCommandNames.add(this.generateCommandHelpPrefix(command.commandName(), command.namespace()));
            StringBuilder aliasSb = new StringBuilder();
            String permission = command.permission().getPermission().orElse("");
            Optional commandHelpTopic = command.helpTopic();
            if (commandHelpTopic.isPresent()) {
                helpTopic = (HelpTopic)commandHelpTopic.get();
                shortDescription = "";
            } else {
                Optional shortDescriptionOptional = command.shortDescription();
                Optional fullDescriptionOptional = command.fullDescription();
                shortDescription = shortDescriptionOptional.isPresent() ? (String)shortDescriptionOptional.get() : (fullDescriptionOptional.isPresent() ? (String)fullDescriptionOptional.get() : "A command by the " + config.getPlugin().getName() + " plugin.");
                StringBuilder sb = new StringBuilder();
                if (fullDescriptionOptional.isPresent()) {
                    sb.append(ChatColor.GOLD).append("Description: ").append(ChatColor.WHITE).append((String)fullDescriptionOptional.get()).append("\n");
                }
                this.generateHelpUsage(sb, command);
                sb.append("\n");
                aliasSb = new StringBuilder(sb.toString());
                if (command.aliases().length > 0) {
                    sb.append(ChatColor.GOLD).append("Aliases: ").append(ChatColor.WHITE).append(String.join((CharSequence)", ", command.aliases()));
                }
                helpTopic = this.generateHelpTopic(commandPrefix, (String)shortDescription, sb.toString().trim(), permission);
            }
            helpTopicsToAdd.put(commandPrefix, helpTopic);
            for (String alias : command.aliases()) {
                if (commandHelpTopic.isPresent()) {
                    helpTopic = (HelpTopic)commandHelpTopic.get();
                } else {
                    StringBuilder currentAliasSb = new StringBuilder(aliasSb.toString());
                    currentAliasSb.append(ChatColor.GOLD).append("Aliases: ").append(ChatColor.WHITE);
                    ArrayList<String> aliases = new ArrayList<String>(Arrays.asList(command.aliases()));
                    aliases.add(command.commandName());
                    aliases.remove(alias);
                    currentAliasSb.append(String.join((CharSequence)", ", aliases));
                    commandPrefix = this.generateCommandHelpPrefix(alias);
                    helpTopic = this.generateHelpTopic(commandPrefix, (String)shortDescription, currentAliasSb.toString().trim(), permission);
                    namespacedCommandNames.add(this.generateCommandHelpPrefix(alias, command.namespace()));
                }
                helpTopicsToAdd.put(commandPrefix, helpTopic);
            }
        }
        this.getHelpMap().putAll(helpTopicsToAdd);
        for (String namespacedCommandName : namespacedCommandNames) {
            this.getHelpMap().remove(namespacedCommandName);
        }
    }

    public void onDisable() {
    }

    public abstract BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<Source> var1, boolean var2);

    public abstract BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(Source var1);

    public abstract Source getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> var1);

    public BukkitCommandSender<? extends CommandSender> wrapCommandSender(CommandSender sender) {
        if (sender instanceof BlockCommandSender) {
            BlockCommandSender block = (BlockCommandSender)sender;
            return new BukkitBlockCommandSender(block);
        }
        if (sender instanceof ConsoleCommandSender) {
            ConsoleCommandSender console = (ConsoleCommandSender)sender;
            return new BukkitConsoleCommandSender(console);
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return new BukkitPlayer(player);
        }
        if (sender instanceof Entity) {
            Entity entity = (Entity)sender;
            return new BukkitEntity(entity);
        }
        if (sender instanceof NativeProxyCommandSender) {
            NativeProxyCommandSender nativeProxy = (NativeProxyCommandSender)sender;
            return new BukkitNativeProxyCommandSender(nativeProxy);
        }
        if (sender instanceof ProxiedCommandSender) {
            ProxiedCommandSender proxy = (ProxiedCommandSender)sender;
            return new BukkitProxiedCommandSender(proxy);
        }
        if (sender instanceof RemoteConsoleCommandSender) {
            RemoteConsoleCommandSender remote = (RemoteConsoleCommandSender)sender;
            return new BukkitRemoteConsoleCommandSender(remote);
        }
        if (this.paper.isPaperPresent()) {
            Class<? extends CommandSender> FeedbackForwardingSender = this.paper.getFeedbackForwardingCommandSender();
            if (FeedbackForwardingSender.isInstance(sender)) {
                return new BukkitFeedbackForwardingCommandSender<CommandSender>(FeedbackForwardingSender.cast(sender));
            }
            Class<? extends CommandSender> NullCommandSender = this.paper.getNullCommandSender();
            if (NullCommandSender != null && NullCommandSender.isInstance(sender)) {
                return null;
            }
        }
        throw new RuntimeException("Failed to wrap CommandSender " + String.valueOf(sender) + " to a CommandAPI-compatible BukkitCommandSender");
    }

    public void registerPermission(String string) {
        try {
            Bukkit.getPluginManager().addPermission(new Permission(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public abstract SuggestionProvider<Source> getSuggestionProvider(SuggestionProviders var1);

    public void preCommandRegistration(String commandName) {
        PluginCommand pluginCommand = Bukkit.getPluginCommand((String)commandName);
        if (pluginCommand == null) {
            return;
        }
        String pluginName = pluginCommand.getPlugin().getName();
        if (config.getPlugin().getName().equals(pluginName)) {
            CommandAPI.logWarning((String)"Plugin command /%s is registered by Bukkit (%s). Did you forget to remove this from your plugin.yml file?".formatted(commandName, pluginName));
        } else {
            CommandAPI.logNormal((String)"Plugin command /%s is registered by Bukkit (%s). You may have to use /minecraft:%s to execute your command.".formatted(commandName, pluginName, commandName));
        }
    }

    public void postCommandRegistration(RegisteredCommand registeredCommand, LiteralCommandNode<Source> resultantNode, List<LiteralCommandNode<Source>> aliasNodes) {
        this.commandRegistrationStrategy.postCommandRegistration(registeredCommand, resultantNode, aliasNodes);
        if (!CommandAPI.canRegister()) {
            this.updateHelpForCommands(List.of(registeredCommand));
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.updateCommands();
            }
        }
    }

    public LiteralCommandNode<Source> registerCommandNode(LiteralArgumentBuilder<Source> node, String namespace) {
        return this.commandRegistrationStrategy.registerCommandNode(node, namespace);
    }

    public void unregister(String commandName, boolean unregisterNamespaces) {
        this.unregisterInternal(commandName, unregisterNamespaces, false);
    }

    public static void unregister(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
        CommandAPIBukkit.get().unregisterInternal(commandName, unregisterNamespaces, unregisterBukkit);
    }

    private void unregisterInternal(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
        CommandAPI.logInfo((String)("Unregistering command /" + commandName));
        this.commandRegistrationStrategy.unregister(commandName, unregisterNamespaces, unregisterBukkit);
        if (!CommandAPI.canRegister()) {
            this.getHelpMap().remove("/" + commandName);
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.updateCommands();
            }
        }
    }

    public final CommandDispatcher<Source> getBrigadierDispatcher() {
        return this.commandRegistrationStrategy.getBrigadierDispatcher();
    }

    public abstract void createDispatcherFile(File var1, CommandDispatcher<Source> var2) throws IOException;

    public abstract <T> T getMinecraftServer();

    public CommandAPILogger getLogger() {
        return new DefaultLogger();
    }

    @Override
    public abstract void reloadDataPacks();

    public void updateRequirements(AbstractPlayer<?> player) {
        ((Player)player.getSource()).updateCommands();
    }

    public Argument<String> newConcreteMultiLiteralArgument(String nodeName, String[] literals) {
        return new MultiLiteralArgument(nodeName, literals);
    }

    public Argument<String> newConcreteLiteralArgument(String nodeName, String literal) {
        return new LiteralArgument(nodeName, literal);
    }

    public CommandAPICommand newConcreteCommandAPICommand(CommandMetaData<CommandSender> meta) {
        return new CommandAPICommand(meta);
    }

    public static WrapperCommandSyntaxException failWithBaseComponents(BaseComponent ... message) {
        return CommandAPI.failWithMessage((Message)BukkitTooltip.messageFromBaseComponents(message));
    }

    public static WrapperCommandSyntaxException failWithAdventureComponent(Component message) {
        return CommandAPI.failWithMessage((Message)BukkitTooltip.messageFromAdventureComponent(message));
    }

    public static WrapperCommandSyntaxException failWithAdventureComponent(ComponentLike message) {
        return CommandAPI.failWithMessage((Message)BukkitTooltip.messageFromAdventureComponent(message.asComponent()));
    }

    public static <T> void initializeNBTAPI(Class<T> nbtContainerClass, Function<Object, T> nbtContainerConstructor) {
        CommandAPIBukkit.getConfiguration().lateInitializeNBT(nbtContainerClass, nbtContainerConstructor);
    }

    protected void registerBukkitRecipesSafely(Iterator<Recipe> recipes) {
        while (recipes.hasNext()) {
            Recipe recipe = recipes.next();
            try {
                Bukkit.addRecipe((Recipe)recipe);
                if (!(recipe instanceof Keyed)) continue;
                Keyed keyedRecipe = (Keyed)recipe;
                CommandAPI.logInfo((String)("Re-registering recipe: " + String.valueOf(keyedRecipe.getKey())));
            }
            catch (IllegalStateException keyedRecipe) {
            }
            catch (Exception e) {
                if (recipe instanceof Keyed) {
                    Keyed keyedRecipe = (Keyed)recipe;
                    CommandAPI.logError((String)("Failed to register recipe " + String.valueOf(keyedRecipe.getKey()) + ": " + e.getMessage()));
                    continue;
                }
                CommandAPI.logError((String)("Failed to register recipe: " + e.getMessage()));
            }
        }
    }

    boolean isInvalidNamespace(String commandName, String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Parameter 'namespace' was null when registering command /" + commandName + "!");
        }
        if (namespace.isEmpty()) {
            CommandAPI.logNormal((String)("Registering command '" + commandName + "' using the default namespace because an empty namespace was given!"));
            return true;
        }
        if (!CommandAPIHandler.NAMESPACE_PATTERN.matcher(namespace).matches()) {
            CommandAPI.logNormal((String)("Registering comand '" + commandName + "' using the default namespace because an invalid namespace (" + namespace + ") was given. Only 0-9, a-z, underscores, periods and hyphens are allowed!"));
            return true;
        }
        return false;
    }

    private static class DefaultLogger
    extends Logger
    implements CommandAPILogger {
        protected DefaultLogger() {
            super("CommandAPI", null);
            this.setParent(Bukkit.getServer().getLogger());
            this.setLevel(Level.ALL);
        }

        public void severe(String message, Throwable exception) {
            super.log(Level.SEVERE, message, exception);
        }
    }
}

