/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.MultiLiteral;
import dev.jorel.commandapi.exceptions.BadLiteralException;
import dev.jorel.commandapi.executors.CommandArguments;
import java.util.List;

public class MultiLiteralArgument
extends Argument<String>
implements MultiLiteral<Argument<String>> {
    private final String[] literals;

    public MultiLiteralArgument(String nodeName, String ... literals) {
        super(nodeName, null);
        if (literals == null) {
            throw new BadLiteralException(true);
        }
        if (literals.length == 0) {
            throw new BadLiteralException(false);
        }
        this.literals = literals;
    }

    @Deprecated(since="9.0.2", forRemoval=true)
    public MultiLiteralArgument(String[] literals) {
        this(null, literals);
    }

    @Deprecated(since="9.1.0", forRemoval=true)
    public MultiLiteralArgument(String nodeName, List<String> literals) {
        this(nodeName, literals.toArray(new String[0]));
    }

    public Class<String> getPrimitiveType() {
        return String.class;
    }

    public String[] getLiterals() {
        return this.literals;
    }

    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.MULTI_LITERAL;
    }

    public <Source> String parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        throw new IllegalStateException("Cannot parse MultiLiteralArgument");
    }
}

