/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.Literal;
import dev.jorel.commandapi.exceptions.BadLiteralException;
import dev.jorel.commandapi.executors.CommandArguments;

public class LiteralArgument
extends Argument<String>
implements Literal<Argument<String>> {
    private final String literal;

    public LiteralArgument(String literal) {
        super(literal, null);
        if (literal == null) {
            throw new BadLiteralException(true);
        }
        if (literal.isEmpty()) {
            throw new BadLiteralException(false);
        }
        this.literal = literal;
        this.setListed(false);
    }

    public Class<String> getPrimitiveType() {
        return String.class;
    }

    public static LiteralArgument of(String literal) {
        return new LiteralArgument(literal);
    }

    public static LiteralArgument literal(String literal) {
        return new LiteralArgument(literal);
    }

    public String getLiteral() {
        return this.literal;
    }

    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LITERAL;
    }

    public <Source> String parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return this.literal;
    }
}

