/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.minestom.extensions;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.minestom.server.MinecraftServer;
import net.minestom.server.extensions.ExtensionManager;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public final class ExtensionBootstrap {
    private static ExtensionManager extensions = null;
    private final MinecraftServer server;

    @NotNull
    public static ExtensionBootstrap init() {
        return new ExtensionBootstrap(MinecraftServer.init());
    }

    @NotNull
    public static ExtensionManager getExtensionManager() {
        Check.notNull((Object)extensions, (String)"ExtensionBootstrap has not been initialized yet!");
        return extensions;
    }

    private ExtensionBootstrap(@NotNull MinecraftServer server) {
        this.server = server;
        extensions = new ExtensionManager(MinecraftServer.process());
        MinecraftServer.getSchedulerManager().buildShutdownTask(extensions::shutdown);
        extensions.start();
        extensions.gotoPreInit();
    }

    public void start(@NotNull String address, int port) {
        this.start(new InetSocketAddress(address, port));
    }

    public void start(@NotNull SocketAddress address) {
        extensions.gotoInit();
        this.server.start(address);
        extensions.gotoPostInit();
    }

    public void shutdown() {
        extensions.shutdown();
    }
}

