/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.util;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import dev.aurelium.slate.util.PaperUtil;
import dev.aurelium.slate.util.VersionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.Nullable;

public class SkullCreator {
    private static boolean warningPosted = false;
    private static final String CRAFTBUKKIT_PACKAGE = Bukkit.getServer().getClass().getPackage().getName();
    private static Field blockProfileField;
    private static Method metaSetProfileMethod;
    private static Field metaProfileField;
    private static Class<?> craftPlayerProfileClass;
    private static Constructor<?> craftPlayerProfileConstructor;
    private static Method buildResolvableProfileMethod;
    private static final Map<String, String> urlDecodeCache;

    private SkullCreator() {
    }

    public static ItemStack createSkull() {
        SkullCreator.checkLegacy();
        try {
            return new ItemStack(Material.valueOf((String)"PLAYER_HEAD"));
        }
        catch (IllegalArgumentException e) {
            return new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
        }
    }

    @Deprecated
    public static ItemStack itemFromName(String name) {
        return SkullCreator.itemWithName(SkullCreator.createSkull(), name);
    }

    public static ItemStack itemFromUuid(UUID id) {
        return SkullCreator.itemWithUuid(SkullCreator.createSkull(), id);
    }

    public static ItemStack itemFromUrl(String url) {
        return SkullCreator.itemWithUrl(SkullCreator.createSkull(), url);
    }

    public static ItemStack itemFromBase64(String base64) {
        return SkullCreator.itemWithBase64(SkullCreator.createSkull(), base64);
    }

    @Deprecated
    public static ItemStack itemWithName(ItemStack item, String name) {
        SkullCreator.notNull(item, "item");
        SkullCreator.notNull(name, "name");
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta != null) {
            meta.setOwner(name);
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    public static ItemStack itemWithUuid(ItemStack item, UUID id) {
        SkullCreator.notNull(item, "item");
        SkullCreator.notNull(id, "id");
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    public static ItemStack itemWithUrl(ItemStack item, String url) {
        SkullCreator.notNull(item, "item");
        SkullCreator.notNull(url, "url");
        return SkullCreator.itemWithBase64(item, SkullCreator.urlToBase64(url));
    }

    public static ItemStack itemWithBase64(ItemStack item, String base64) {
        SkullCreator.notNull(item, "item");
        SkullCreator.notNull(base64, "base64");
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return null;
        }
        SkullMeta meta = (SkullMeta)itemMeta;
        SkullCreator.mutateItemMeta(meta, base64);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    @Deprecated
    public static void blockWithName(Block block, String name) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(name, "name");
        Skull state = (Skull)block.getState();
        state.setOwningPlayer(Bukkit.getOfflinePlayer((String)name));
        state.update(false, false);
    }

    public static void blockWithUuid(Block block, UUID id) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(id, "id");
        SkullCreator.setToSkull(block);
        Skull state = (Skull)block.getState();
        state.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
        state.update(false, false);
    }

    public static void blockWithUrl(Block block, String url) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(url, "url");
        SkullCreator.blockWithBase64(block, SkullCreator.urlToBase64(url));
    }

    public static void blockWithBase64(Block block, String base64) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(base64, "base64");
        SkullCreator.setToSkull(block);
        Skull state = (Skull)block.getState();
        SkullCreator.mutateBlockState(state, base64);
        state.update(false, false);
    }

    private static void setToSkull(Block block) {
        SkullCreator.checkLegacy();
        try {
            block.setType(Material.valueOf((String)"PLAYER_HEAD"), false);
        }
        catch (IllegalArgumentException e) {
            block.setType(Material.valueOf((String)"SKULL"), false);
            Skull state = (Skull)block.getState();
            state.setSkullType(SkullType.PLAYER);
            state.update(false, false);
        }
    }

    private static void notNull(Object o, String name) {
        if (o == null) {
            throw new NullPointerException(name + " should not be null!");
        }
    }

    private static String urlToBase64(String url) {
        URI actualUrl;
        try {
            actualUrl = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String toEncode = "{\"textures\":{\"SKIN\":{\"url\":\"" + actualUrl + "\"}}}";
        return Base64.getEncoder().encodeToString(toEncode.getBytes());
    }

    private static GameProfile makeProfile(String b64) {
        UUID id = new UUID(b64.substring(b64.length() - 20).hashCode(), b64.substring(b64.length() - 10).hashCode());
        GameProfile profile = new GameProfile(id, "Player");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", b64));
        return profile;
    }

    private static void mutateBlockState(Skull block, String b64) {
        try {
            if (blockProfileField == null) {
                blockProfileField = block.getClass().getDeclaredField("profile");
                blockProfileField.setAccessible(true);
            }
            blockProfileField.set(block, SkullCreator.makeProfile(b64));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static String decodeSkinUrl(String base64Texture) {
        String cached = urlDecodeCache.get(base64Texture);
        if (cached != null) {
            return cached;
        }
        String decoded = new String(Base64.getDecoder().decode(base64Texture));
        JsonObject object = JsonParser.parseString((String)decoded).getAsJsonObject();
        JsonElement textures = object.get("textures");
        if (textures == null) {
            return null;
        }
        JsonElement skin = textures.getAsJsonObject().get("SKIN");
        if (skin == null) {
            return null;
        }
        JsonElement url = skin.getAsJsonObject().get("url");
        if (url != null) {
            urlDecodeCache.put(base64Texture, url.getAsString());
            return url.getAsString();
        }
        return null;
    }

    private static void mutateItemMeta(SkullMeta meta, String b64) {
        block16: {
            if (VersionUtil.isAtLeastVersion(18, 1)) {
                String url = SkullCreator.decodeSkinUrl(b64);
                if (url != null) {
                    try {
                        if (PaperUtil.IS_PAPER) {
                            PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID());
                            PlayerTextures textures = profile.getTextures();
                            textures.setSkin(new URL(url));
                            profile.setTextures(textures);
                            meta.setPlayerProfile(profile);
                            break block16;
                        }
                        org.bukkit.profile.PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
                        profile.getTextures().setSkin(new URL(url));
                        meta.setOwnerProfile(profile);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    if (metaSetProfileMethod == null) {
                        metaSetProfileMethod = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                        metaSetProfileMethod.setAccessible(true);
                    }
                    metaSetProfileMethod.invoke((Object)meta, SkullCreator.makeProfile(b64));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    try {
                        if (metaProfileField == null) {
                            metaProfileField = meta.getClass().getDeclaredField("profile");
                            metaProfileField.setAccessible(true);
                        }
                        metaProfileField.set(meta, SkullCreator.makeProfile(b64));
                    }
                    catch (IllegalAccessException | NoSuchFieldException ex2) {
                        ex2.printStackTrace();
                    }
                    catch (IllegalArgumentException ex3) {
                        try {
                            if (craftPlayerProfileClass == null || craftPlayerProfileConstructor == null || buildResolvableProfileMethod == null) {
                                craftPlayerProfileClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".profile.CraftPlayerProfile");
                                craftPlayerProfileConstructor = craftPlayerProfileClass.getDeclaredConstructor(GameProfile.class);
                                buildResolvableProfileMethod = craftPlayerProfileClass.getDeclaredMethod("buildResolvableProfile", new Class[0]);
                            }
                            Object playerProfileInst = craftPlayerProfileConstructor.newInstance(SkullCreator.makeProfile(b64));
                            Object resolvableProfileInst = buildResolvableProfileMethod.invoke(playerProfileInst, new Object[0]);
                            metaProfileField.set(meta, resolvableProfileInst);
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex4) {
                            ex4.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private static void checkLegacy() {
        try {
            Material.class.getDeclaredField("PLAYER_HEAD");
            Material.valueOf((String)"SKULL");
            if (!warningPosted) {
                Bukkit.getLogger().warning("SKULLCREATOR API - Using the legacy bukkit API with 1.13+ bukkit versions is not supported!");
                warningPosted = true;
            }
        }
        catch (IllegalArgumentException | NoSuchFieldException exception) {
            // empty catch block
        }
    }

    static {
        urlDecodeCache = new HashMap<String, String>();
    }
}

