/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.inv.util;

import com.google.common.base.Preconditions;
import dev.aurelium.slate.inv.content.SlotPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Pattern<T> {
    private T defaultValue;
    private final String[] lines;
    private final Map<Character, T> mapping = new HashMap<Character, T>();
    private final boolean wrapAround;

    public Pattern(String ... lines) {
        this(false, lines);
    }

    public Pattern(boolean wrapAround, String ... lines) {
        Preconditions.checkNotNull((Object)lines, (Object)"The given pattern lines must not be null.");
        Preconditions.checkArgument((lines.length > 0 ? 1 : 0) != 0, (Object)"The given pattern lines must not be empty.");
        int columnCount = lines[0].length();
        this.lines = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            Preconditions.checkNotNull((Object)line, (String)"The given pattern line %s cannot be null.", (int)i);
            Preconditions.checkArgument((line.length() == columnCount ? 1 : 0) != 0, (String)"The given pattern line %s does not match the first line character count.", (int)i);
            this.lines[i] = lines[i];
        }
        this.wrapAround = wrapAround;
    }

    public Pattern<T> attach(char character, T object) {
        this.mapping.put(Character.valueOf(character), object);
        return this;
    }

    public T getObject(int index) {
        int columnCount = this.getColumnCount();
        return this.getObject(index / columnCount, index % columnCount);
    }

    public T getObject(SlotPos slot) {
        return this.getObject(slot.getRow(), slot.getColumn());
    }

    public T getObject(int row, int column) {
        if (this.wrapAround) {
            if ((row %= this.getRowCount()) < 0) {
                row += this.getRowCount();
            }
            if ((column %= this.getColumnCount()) < 0) {
                column += this.getColumnCount();
            }
        } else {
            Preconditions.checkElementIndex((int)row, (int)this.lines.length, (String)"The row must be between 0 and the row count");
            Preconditions.checkElementIndex((int)column, (int)this.lines[0].length(), (String)"The column must be between 0 and the column size");
        }
        return this.mapping.getOrDefault(Character.valueOf(this.lines[row].charAt(column)), this.defaultValue);
    }

    public Optional<SlotPos> findKey(char character) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                if (this.lines[row].charAt(column) != character) continue;
                return Optional.of(SlotPos.of(row, column));
            }
        }
        return Optional.empty();
    }

    public List<SlotPos> findAllKeys(char character) {
        ArrayList<SlotPos> positions = new ArrayList<SlotPos>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                if (this.lines[row].charAt(column) != character) continue;
                positions.add(SlotPos.of(row, column));
            }
        }
        return positions;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public Pattern<T> setDefault(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public int getRowCount() {
        return this.lines.length;
    }

    public int getColumnCount() {
        return this.lines[0].length();
    }

    public boolean isWrapAround() {
        return this.wrapAround;
    }
}

