/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.action.condition;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.action.condition.Condition;
import dev.aurelium.slate.menu.MenuInventory;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public class PlaceholderCondition
extends Condition {
    private final String placeholder;
    private final String value;
    private final Compare compare;

    public PlaceholderCondition(Slate slate, String placeholder, String value, Compare compare) {
        super(slate);
        this.placeholder = placeholder;
        this.value = value;
        this.compare = compare;
    }

    @Override
    public boolean isMet(Player player, MenuInventory menuInventory) {
        String leftText = this.replaceProperties(this.placeholder, menuInventory);
        if (this.slate.isPlaceholderAPIEnabled()) {
            leftText = PlaceholderAPI.setPlaceholders((Player)player, (String)leftText);
        }
        String rightText = this.replaceProperties(this.value, menuInventory);
        if (this.slate.isPlaceholderAPIEnabled()) {
            rightText = PlaceholderAPI.setPlaceholders((Player)player, (String)rightText);
        }
        try {
            return this.compare.test(leftText, rightText);
        }
        catch (NumberFormatException e) {
            this.slate.getPlugin().getLogger().warning("Slate: Failed to evaluate placeholder condition in menu " + menuInventory.getMenu().name());
            e.printStackTrace();
            return false;
        }
    }

    private String replaceProperties(String text, MenuInventory menu) {
        for (Map.Entry<String, Object> property : menu.getProperties().entrySet()) {
            String key = property.getKey();
            Object value = property.getValue();
            text = text.replace("{" + key + "}", value.toString());
        }
        return text;
    }

    public static enum Compare {
        EQUALS((left, right) -> {
            try {
                double leftDouble = Double.parseDouble(left);
                double rightDouble = Double.parseDouble(right);
                return Double.compare(leftDouble, rightDouble) == 0;
            }
            catch (NumberFormatException e) {
                return left.equals(right);
            }
        }),
        GREATER_THAN((left, right) -> {
            double rightDouble;
            double leftDouble = Double.parseDouble(left);
            return leftDouble > (rightDouble = Double.parseDouble(right));
        }),
        GREATER_THAN_OR_EQUALS((left, right) -> {
            double rightDouble;
            double leftDouble = Double.parseDouble(left);
            return leftDouble >= (rightDouble = Double.parseDouble(right));
        }),
        LESS_THAN((left, right) -> {
            double rightDouble;
            double leftDouble = Double.parseDouble(left);
            return leftDouble < (rightDouble = Double.parseDouble(right));
        }),
        LESS_THAN_OR_EQUALS((left, right) -> {
            double rightDouble;
            double leftDouble = Double.parseDouble(left);
            return leftDouble <= (rightDouble = Double.parseDouble(right));
        });

        private final ComparisonTest test;

        private Compare(ComparisonTest test) {
            this.test = test;
        }

        public boolean test(String left, String right) throws NumberFormatException {
            return this.test.test(left, right);
        }
    }

    static interface ComparisonTest {
        public boolean test(String var1, String var2);
    }
}

