/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.action;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.action.Action;
import dev.aurelium.slate.action.parser.CommandActionParser;
import dev.aurelium.slate.action.parser.MenuActionParser;
import dev.aurelium.slate.action.parser.SoundActionParser;
import dev.aurelium.slate.util.MapParser;
import dev.aurelium.slate.util.YamlLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.spongepowered.configurate.ConfigurationNode;

public class ActionManager
extends MapParser {
    private final Slate slate;

    public ActionManager(Slate slate) {
        this.slate = slate;
    }

    public List<Action> parseActions(ConfigurationNode config, String menuName) {
        ArrayList<Action> actions = new ArrayList<Action>();
        int index = 0;
        for (ConfigurationNode actionNode : config.childrenList()) {
            try {
                String type;
                Action action = switch (type = Objects.requireNonNull(this.detectType(actionNode))) {
                    case "command" -> new CommandActionParser(this.slate).parse(actionNode);
                    case "menu" -> new MenuActionParser(this.slate).parse(actionNode);
                    case "sound" -> new SoundActionParser(this.slate).parse(actionNode);
                    default -> throw new IllegalArgumentException("Action with type " + type + " not found");
                };
                actions.add(action);
            }
            catch (RuntimeException e) {
                this.slate.getPlugin().getLogger().warning("Error parsing action in menu " + menuName + " at path " + YamlLoader.toDotString(config.path()) + ".[" + index + "], see below for error:");
                e.printStackTrace();
            }
            ++index;
        }
        return actions;
    }

    @Nullable
    private String detectType(ConfigurationNode node) {
        String type = node.node(new Object[]{"type"}).getString();
        if (type != null) {
            return type.toLowerCase(Locale.ROOT);
        }
        if (!node.node(new Object[]{"command"}).virtual()) {
            return "command";
        }
        if (!node.node(new Object[]{"menu"}).virtual()) {
            return "menu";
        }
        if (!node.node(new Object[]{"sound"}).virtual()) {
            return "sound";
        }
        return null;
    }
}

