/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class YamlLoader {
    private final Plugin plugin;

    public YamlLoader(Plugin plugin) {
        this.plugin = plugin;
    }

    @Nullable
    public ConfigurationNode loadEmbeddedFile(String path) {
        ConfigurationNode configurationNode;
        block9: {
            URL url = this.getClass().getClassLoader().getResource(path);
            if (url == null) {
                return null;
            }
            URI uri = url.toURI();
            FileSystem ignored = FileSystems.newFileSystem(uri, Map.of("create", "true"));
            try {
                YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(Path.of(uri))).build();
                configurationNode = loader.load();
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException e) {
                    this.plugin.getLogger().warning("Failed to load embedded file " + path);
                    return null;
                }
            }
            ignored.close();
        }
        return configurationNode;
    }

    public ConfigurationNode loadUserFile(File file) throws ConfigurateException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(file.toPath())).nodeStyle(NodeStyle.BLOCK).indent(2).build();
        return loader.load();
    }

    public void saveFile(File file, ConfigurationNode config) throws ConfigurateException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(file)).nodeStyle(NodeStyle.BLOCK).indent(2).build();
        loader.save(config);
    }

    public void saveIfUpdated(File file, ConfigurationNode embedded, ConfigurationNode user, ConfigurationNode merged) throws ConfigurateException {
        int userCount;
        int embeddedCount = this.getLeafNodes(embedded).size();
        if (embeddedCount > (userCount = this.getLeafNodes(user).size())) {
            this.saveFile(file, merged);
            String path = this.plugin.getDataFolder().toPath().relativize(file.toPath()).toString();
            int updated = embeddedCount - userCount;
            this.plugin.getLogger().info("Updated " + path + " with " + updated + " new key" + (updated != 1 ? "s" : ""));
        }
    }

    public void generateUserFile(String path) throws ConfigurateException {
        ConfigurationNode config = this.loadEmbeddedFile(path);
        if (config == null) {
            return;
        }
        File file = new File(this.plugin.getDataFolder(), path);
        if (!file.exists()) {
            this.saveFile(file, config);
        }
    }

    public List<ConfigurationNode> getLeafNodes(ConfigurationNode root) {
        ArrayList<ConfigurationNode> leafNodes = new ArrayList<ConfigurationNode>();
        Stack toProcess = new Stack();
        toProcess.addAll(root.childrenMap().values());
        while (!toProcess.isEmpty()) {
            ConfigurationNode node = (ConfigurationNode)toProcess.pop();
            if (node.isMap()) {
                toProcess.addAll(node.childrenMap().values());
                continue;
            }
            leafNodes.add(node);
        }
        return leafNodes;
    }

    public ConfigurationNode mergeNodes(ConfigurationNode ... nodes) throws SerializationException {
        if (nodes.length == 0) {
            throw new IllegalArgumentException("Must provide at least one node");
        }
        ConfigurationNode merged = nodes[0].copy();
        for (ConfigurationNode node : nodes) {
            this.mergeRec(merged, node);
        }
        return merged;
    }

    public String toDotString(NodePath nodePath) {
        StringBuilder sb = new StringBuilder();
        for (Object segment : nodePath.array()) {
            sb.append(segment).append(".");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private void mergeRec(ConfigurationNode base, ConfigurationNode source) throws SerializationException {
        for (ConfigurationNode child : source.childrenMap().values()) {
            if (child.isMap()) {
                this.mergeRec(base.node(new Object[]{child.key()}), child);
                continue;
            }
            base.node(new Object[]{child.key()}).set(child.raw());
        }
    }
}

