/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.item.parser;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.context.ContextGroup;
import dev.aurelium.slate.context.ContextProvider;
import dev.aurelium.slate.context.GroupAlign;
import dev.aurelium.slate.inv.content.SlotPos;
import dev.aurelium.slate.item.MenuItem;
import dev.aurelium.slate.item.builder.TemplateItemBuilder;
import dev.aurelium.slate.item.parser.MenuItemParser;
import dev.aurelium.slate.lore.LoreLine;
import dev.aurelium.slate.menu.MenuLoader;
import dev.aurelium.slate.position.FixedPosition;
import dev.aurelium.slate.position.GroupPosition;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;

public class TemplateItemParser<C>
extends MenuItemParser {
    @NotNull
    private final ContextProvider<C> contextProvider;

    public TemplateItemParser(Slate slate, @NotNull ContextProvider<C> contextProvider) {
        super(slate);
        this.contextProvider = contextProvider;
    }

    @Override
    public MenuItem parse(ConfigurationNode section, String menuName) {
        TemplateItemBuilder<Object> builder = new TemplateItemBuilder<Object>(this.slate);
        String name = (String)Objects.requireNonNull(section.key());
        builder.name(name);
        builder.contextClass(this.contextProvider.getType());
        Map<String, ContextGroup> groups = this.loadGroups(section);
        builder.contextGroups(groups);
        HashMap<C, ItemStack> baseItems = new HashMap<C, ItemStack>();
        HashMap<C, Record> positions = new HashMap<C, Record>();
        HashMap<C, String> contextualDisplayNames = new HashMap<C, String>();
        HashMap<C, List<LoreLine>> contextualLore = new HashMap<C, List<LoreLine>>();
        for (ConfigurationNode contextNode : section.node(new Object[]{"contexts"}).childrenMap().values()) {
            List<LoreLine> contextualLoreList;
            String positionString;
            String key = contextNode.key() instanceof String ? (String)Objects.requireNonNull(contextNode.key()) : String.valueOf(contextNode.key());
            C context = this.contextProvider.parse(menuName, key);
            if (context == null) continue;
            if (!contextNode.node(new Object[]{"material"}).virtual() || !contextNode.node(new Object[]{"key"}).virtual()) {
                baseItems.put(context, this.itemParser.parseBaseItem(contextNode));
            }
            if ((positionString = contextNode.node(new Object[]{"pos"}).getString()) != null) {
                positions.put(context, new FixedPosition(this.parsePosition(positionString)));
            } else if (!contextNode.node(new Object[]{"group"}).virtual()) {
                String groupName = contextNode.node(new Object[]{"group"}).getString();
                ContextGroup group = groups.get(groupName);
                if (group == null) {
                    positions.put(context, new FixedPosition(this.parsePosition("0,0")));
                } else {
                    int order = contextNode.node(new Object[]{"order"}).getInt(1);
                    positions.put(context, new GroupPosition(group, order));
                }
            }
            String contextualDisplayName = this.itemParser.parseDisplayName(contextNode);
            if (contextualDisplayName != null) {
                contextualDisplayNames.put(context, contextualDisplayName);
            }
            if ((contextualLoreList = this.itemParser.parseLore(contextNode)).isEmpty()) continue;
            contextualLore.put(context, contextualLoreList);
        }
        builder.contextualDisplayNames(contextualDisplayNames);
        builder.contextualLore(contextualLore);
        String defaultPos = section.node(new Object[]{"pos"}).getString();
        if (positions.isEmpty() && defaultPos != null) {
            SlotPos pos = this.parsePosition(defaultPos);
            builder.defaultPosition(pos);
        }
        builder.baseItems(baseItems);
        builder.positions(positions);
        if (!section.node(new Object[]{"material"}).virtual() || !section.node(new Object[]{"key"}).virtual()) {
            builder.defaultBaseItem(this.itemParser.parseBaseItem(section));
        }
        builder.displayName(this.itemParser.parseDisplayName(section));
        builder.lore(this.itemParser.parseLore(section));
        this.parseActions(builder, section, menuName, name);
        builder.options(MenuLoader.loadOptions(section));
        return builder.build();
    }

    private Map<String, ContextGroup> loadGroups(ConfigurationNode section) {
        HashMap<String, ContextGroup> groups = new HashMap<String, ContextGroup>();
        for (ConfigurationNode groupNode : section.node(new Object[]{"groups"}).childrenMap().values()) {
            String groupName = (String)groupNode.key();
            if (groupName == null) continue;
            SlotPos start = this.parsePosition(groupNode.node(new Object[]{"start"}).getString("0,0"));
            SlotPos end = this.parsePosition(groupNode.node(new Object[]{"end"}).getString("0,0"));
            GroupAlign align = GroupAlign.valueOf(groupNode.node(new Object[]{"align"}).getString("CENTER").toUpperCase(Locale.ROOT));
            groups.put(groupName, new ContextGroup(start, end, align));
        }
        return groups;
    }
}

