/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.item.parser;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.action.Action;
import dev.aurelium.slate.action.click.ClickAction;
import dev.aurelium.slate.inv.content.SlotPos;
import dev.aurelium.slate.item.MenuItem;
import dev.aurelium.slate.item.builder.MenuItemBuilder;
import dev.aurelium.slate.item.parser.ConfigurateItemParser;
import dev.aurelium.slate.util.MapParser;
import java.util.LinkedHashMap;
import java.util.List;
import org.spongepowered.configurate.ConfigurationNode;

public abstract class MenuItemParser
extends MapParser {
    protected final Slate slate;
    protected final ConfigurateItemParser itemParser;

    public MenuItemParser(Slate slate) {
        this.slate = slate;
        this.itemParser = new ConfigurateItemParser(slate);
    }

    public abstract MenuItem parse(ConfigurationNode var1, String var2);

    protected SlotPos parsePosition(String input) {
        String[] splitInput = input.split(",", 2);
        if (splitInput.length == 2) {
            int row = Integer.parseInt(splitInput[0]);
            int column = Integer.parseInt(splitInput[1]);
            return SlotPos.of(row, column);
        }
        int slot = Integer.parseInt(input);
        int row = slot / 9;
        int column = slot % 9;
        return SlotPos.of(row, column);
    }

    protected void parseActions(MenuItemBuilder builder, ConfigurationNode config, String menuName, String itemName) {
        LinkedHashMap<ClickAction, List<Action>> actions = new LinkedHashMap<ClickAction, List<Action>>();
        for (ClickAction clickAction : ClickAction.values()) {
            String id = clickAction.getId();
            if (config.node(new Object[]{id}).virtual()) continue;
            List<Action> clickActions = this.slate.getActionManager().parseActions(config.node(new Object[]{id}), menuName, itemName);
            actions.put(clickAction, clickActions);
        }
        builder.actions(actions);
    }
}

