/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.item.parser;

import de.tr7zw.changeme.nbtapi.NBTCompound;
import de.tr7zw.changeme.nbtapi.NBTContainer;
import de.tr7zw.changeme.nbtapi.NBTItem;
import dev.aurelium.slate.Slate;
import dev.aurelium.slate.item.provider.KeyedItemProvider;
import dev.aurelium.slate.lore.LoreFactory;
import dev.aurelium.slate.lore.LoreLine;
import dev.aurelium.slate.util.NumberUtil;
import dev.aurelium.slate.util.SkullCreator;
import dev.aurelium.slate.util.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class ConfigurateItemParser {
    private final Slate slate;
    private final Plugin plugin;

    public ConfigurateItemParser(Slate slate) {
        this.slate = slate;
        this.plugin = slate.getPlugin();
    }

    public ItemStack parseBaseItem(ConfigurationNode config) {
        ConfigurationNode skullMetaSection;
        ConfigurationNode potionDataSection;
        ItemStack item;
        String key = config.node(new Object[]{"key"}).getString();
        if (key != null && (item = this.parseItemKey(key)) != null) {
            return item;
        }
        String materialString = config.node(new Object[]{"material"}).getString();
        Validate.notNull(materialString, "Item must specify a material");
        ItemStack item2 = this.parseMaterialString(materialString);
        this.parseAmount(item2, config);
        ItemMeta meta = item2.getItemMeta();
        if (meta == null) {
            return item2;
        }
        if (!config.node(new Object[]{"enchantments"}).virtual()) {
            this.parseEnchantments(item2, config);
        }
        if (!(potionDataSection = config.node(new Object[]{"potion_data"})).virtual()) {
            this.parsePotionData(item2, potionDataSection);
        }
        if (!config.node(new Object[]{"custom_effects"}).virtual()) {
            this.parseCustomEffects(config, item2);
        }
        if (config.node(new Object[]{"glow"}).getBoolean(false)) {
            this.parseGlow(item2);
        }
        if (!config.node(new Object[]{"nbt"}).virtual()) {
            String nbtString;
            if (config.node(new Object[]{"nbt"}).isMap()) {
                ConfigurationNode nbtSection = config.node(new Object[]{"nbt"});
                item2 = this.parseNBT(item2, nbtSection.childrenMap());
            } else if (config.node(new Object[]{"nbt"}).getString() != null && (nbtString = config.getString("nbt")) != null) {
                item2 = this.parseNBTString(item2, nbtString);
            }
        }
        if (!config.node(new Object[]{"flags"}).virtual()) {
            this.parseFlags(config, item2);
        }
        if (!config.node(new Object[]{"durability"}).virtual()) {
            this.parseDurability(config, item2);
        }
        if (!(skullMetaSection = config.node(new Object[]{"skull_meta"})).virtual()) {
            this.parseSkullMeta(item2, item2.getItemMeta(), skullMetaSection);
        }
        return item2;
    }

    @Nullable
    private ItemStack parseItemKey(String key) {
        KeyedItemProvider provider = this.slate.getOptions().keyedItemProvider();
        if (provider != null) {
            return provider.getItem(key);
        }
        return null;
    }

    private void parseDurability(ConfigurationNode section, ItemStack item) {
        ItemMeta meta = this.getMeta(item);
        int durability = section.node(new Object[]{"durability"}).getInt();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            short maxDurability = item.getType().getMaxDurability();
            damageable.setDamage(Math.max(maxDurability - durability, maxDurability));
            item.setItemMeta(meta);
        }
    }

    private void parseFlags(ConfigurationNode section, ItemStack item) {
        try {
            ItemMeta meta = this.getMeta(item);
            List flags = section.node(new Object[]{"flags"}).getList(String.class, new ArrayList());
            for (String flagName : flags) {
                ItemFlag itemFlag = ItemFlag.valueOf((String)flagName.toUpperCase(Locale.ROOT));
                meta.addItemFlags(new ItemFlag[]{itemFlag});
            }
            item.setItemMeta(meta);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
    }

    private void parseGlow(ItemStack item) {
        ItemMeta meta = this.getMeta(item);
        meta.addEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
    }

    private void parseCustomEffects(ConfigurationNode section, ItemStack item) {
        PotionMeta potionMeta = (PotionMeta)this.getMeta(item);
        for (ConfigurationNode effectNode : section.node(new Object[]{"custom_effects"}).childrenList()) {
            String effectName = effectNode.node(new Object[]{"type"}).getString("SPEED");
            PotionEffectType type = PotionEffectType.getByName((String)effectName);
            if (type != null) {
                int duration = effectNode.node(new Object[]{"duration"}).getInt();
                int amplifier = effectNode.node(new Object[]{"amplifier"}).getInt();
                potionMeta.addCustomEffect(new PotionEffect(type, duration, amplifier), true);
                potionMeta.setColor(type.getColor());
                continue;
            }
            throw new IllegalArgumentException("Invalid potion effect type " + effectName);
        }
        item.setItemMeta((ItemMeta)potionMeta);
    }

    private void parsePotionData(ItemStack item, ConfigurationNode node) {
        PotionMeta potionMeta = (PotionMeta)this.getMeta(item);
        PotionType potionType = PotionType.valueOf((String)node.node(new Object[]{"type"}).getString("WATER").toUpperCase(Locale.ROOT));
        boolean extended = node.node(new Object[]{"extended"}).getBoolean(false);
        boolean upgraded = node.node(new Object[]{"upgraded"}).getBoolean(false);
        PotionData potionData = new PotionData(potionType, extended, upgraded);
        potionMeta.setBasePotionData(potionData);
        item.setItemMeta((ItemMeta)potionMeta);
    }

    private void parseEnchantments(ItemStack item, ConfigurationNode section) {
        try {
            ItemMeta meta = this.getMeta(item);
            List enchantmentStrings = section.node(new Object[]{"enchantments"}).getList(String.class, new ArrayList());
            for (String enchantmentEntry : enchantmentStrings) {
                Enchantment enchantment;
                String[] splitEntry = enchantmentEntry.split(" ");
                String enchantmentName = splitEntry[0];
                int level = 1;
                if (splitEntry.length > 1) {
                    level = NumberUtil.toInt(splitEntry[1], 1);
                }
                if ((enchantment = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)enchantmentName.toLowerCase(Locale.ROOT)))) != null) {
                    if (item.getType() == Material.ENCHANTED_BOOK && meta instanceof EnchantmentStorageMeta) {
                        EnchantmentStorageMeta esm = (EnchantmentStorageMeta)meta;
                        esm.addStoredEnchant(enchantment, level, true);
                        item.setItemMeta((ItemMeta)esm);
                        continue;
                    }
                    meta.addEnchant(enchantment, level, true);
                    item.setItemMeta(meta);
                    continue;
                }
                throw new IllegalArgumentException("Invalid enchantment name " + enchantmentName);
            }
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
    }

    private ItemStack parseMaterialString(String materialString) {
        String materialName = materialString.toUpperCase(Locale.ROOT);
        Material material = this.parseMaterial(materialName);
        if (material == null) {
            throw new IllegalArgumentException("Unknown material " + materialString);
        }
        if (!material.isItem()) {
            return new ItemStack(Material.GRAY_DYE);
        }
        ItemStack item = new ItemStack(material);
        return item;
    }

    @NotNull
    private ItemMeta getMeta(ItemStack item) {
        return Objects.requireNonNull(item.getItemMeta());
    }

    @Nullable
    public String parseDisplayName(ConfigurationNode section) {
        if (!section.node(new Object[]{"display_name"}).virtual()) {
            return section.node(new Object[]{"display_name"}).getString();
        }
        return null;
    }

    @NotNull
    public List<LoreLine> parseLore(ConfigurationNode section) {
        ConfigurationNode loreNode = section.node(new Object[]{"lore"});
        return new LoreFactory(this.slate).getLore(loreNode);
    }

    private ItemStack parseNBT(ItemStack item, Map<Object, ? extends ConfigurationNode> map) {
        NBTItem nbtItem = new NBTItem(item);
        this.applyMapToNBT((NBTCompound)nbtItem, map);
        return nbtItem.getItem();
    }

    private void applyMapToNBT(NBTCompound item, Map<Object, ? extends ConfigurationNode> map) {
        for (Map.Entry<Object, ? extends ConfigurationNode> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue().raw();
            if (!(key instanceof String)) continue;
            if (value instanceof ConfigurationNode) {
                ConfigurationNode childNode = (ConfigurationNode)value;
                this.applyMapToNBT(item.getOrCreateCompound((String)key), childNode.childrenMap());
                continue;
            }
            if (value instanceof Integer) {
                item.setInteger((String)key, Integer.valueOf((Integer)value));
                continue;
            }
            if (value instanceof Double) {
                item.setDouble((String)key, Double.valueOf((Double)value));
                continue;
            }
            if (value instanceof Boolean) {
                item.setBoolean((String)key, Boolean.valueOf((Boolean)value));
                continue;
            }
            if (!(value instanceof String)) continue;
            item.setString((String)key, (String)value);
        }
    }

    private ItemStack parseNBTString(ItemStack item, String nbtString) {
        NBTContainer container = new NBTContainer(nbtString);
        NBTItem nbtItem = new NBTItem(item);
        nbtItem.mergeCompound((NBTCompound)container);
        return nbtItem.getItem();
    }

    protected Material parseMaterial(String name) {
        return Material.getMaterial((String)name);
    }

    private void parseSkullMeta(ItemStack item, ItemMeta meta, ConfigurationNode section) {
        String placeholder;
        String url;
        String base64;
        if (!(meta instanceof SkullMeta)) {
            return;
        }
        SkullMeta skullMeta = (SkullMeta)meta;
        String uuid = section.node(new Object[]{"uuid"}).getString();
        if (uuid != null) {
            UUID id = UUID.fromString(uuid);
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
            item.setItemMeta(meta);
        }
        if ((base64 = section.node(new Object[]{"base64"}).getString()) != null) {
            SkullCreator.itemWithBase64(item, base64);
        }
        if ((url = section.node(new Object[]{"url"}).getString()) != null) {
            SkullCreator.itemWithUrl(item, url);
        }
        if ((placeholder = section.node(new Object[]{"placeholder_uuid"}).getString()) != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            NamespacedKey key = new NamespacedKey(this.plugin, "skull_placeholder_uuid");
            container.set(key, PersistentDataType.STRING, (Object)placeholder);
            item.setItemMeta(meta);
        }
    }

    private void parseAmount(ItemStack item, ConfigurationNode section) {
        int amount = section.node(new Object[]{"amount"}).getInt(1);
        item.setAmount(amount);
    }
}

