/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.builder;

import dev.aurelium.slate.action.click.ClickAction;
import dev.aurelium.slate.builder.BuiltTemplate;
import dev.aurelium.slate.function.ContextListener;
import dev.aurelium.slate.function.DefinedContexts;
import dev.aurelium.slate.function.MenuListener;
import dev.aurelium.slate.function.TemplateClicker;
import dev.aurelium.slate.function.TemplateModifier;
import dev.aurelium.slate.function.TemplateReplacer;
import dev.aurelium.slate.function.TemplateSlot;
import dev.aurelium.slate.info.ItemInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TemplateBuilder<T> {
    private final Class<T> contextType;
    private final Map<String, TemplateReplacer<T>> replacers = new HashMap<String, TemplateReplacer<T>>();
    private TemplateReplacer<T> anyReplacer = p -> null;
    private final Map<ClickAction, TemplateClicker<T>> clickers = new HashMap<ClickAction, TemplateClicker<T>>();
    private TemplateModifier<T> modifier = ItemInfo::item;
    private DefinedContexts<T> definedContexts = m -> new HashSet();
    private TemplateSlot<T> slotProvider = t -> null;
    private MenuListener initListener = m -> {};
    private ContextListener<T> contextListener = t -> {};

    public TemplateBuilder(Class<T> contextType) {
        this.contextType = contextType;
    }

    public static <T> TemplateBuilder<T> builder(Class<T> type) {
        return new TemplateBuilder<T>(type);
    }

    public TemplateBuilder<T> replace(String from, TemplateReplacer<T> replacer) {
        this.replacers.put(from, replacer);
        return this;
    }

    public TemplateBuilder<T> replaceAny(TemplateReplacer<T> replacer) {
        this.anyReplacer = replacer;
        return this;
    }

    public TemplateBuilder<T> onClick(TemplateClicker<T> clicker) {
        this.clickers.put(ClickAction.ANY, clicker);
        return this;
    }

    public TemplateBuilder<T> onClick(ClickAction action, TemplateClicker<T> clicker) {
        this.clickers.put(action, clicker);
        return this;
    }

    public TemplateBuilder<T> modify(TemplateModifier<T> modifier) {
        this.modifier = modifier;
        return this;
    }

    public TemplateBuilder<T> definedContexts(DefinedContexts<T> context) {
        this.definedContexts = context;
        return this;
    }

    public TemplateBuilder<T> slotPos(TemplateSlot<T> slot) {
        this.slotProvider = slot;
        return this;
    }

    public TemplateBuilder<T> initialize(MenuListener listener) {
        this.initListener = listener;
        return this;
    }

    public TemplateBuilder<T> initializeContext(ContextListener<T> listener) {
        this.contextListener = listener;
        return this;
    }

    public BuiltTemplate<T> build() {
        return new BuiltTemplate<T>(this.contextType, this.replacers, this.anyReplacer, this.clickers, this.modifier, this.definedContexts, this.slotProvider, this.initListener, this.contextListener);
    }
}

