/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.builder;

import dev.aurelium.slate.builder.BuiltItem;
import dev.aurelium.slate.builder.BuiltMenu;
import dev.aurelium.slate.builder.ComponentBuilder;
import dev.aurelium.slate.builder.ItemBuilder;
import dev.aurelium.slate.builder.TemplateBuilder;
import dev.aurelium.slate.function.ItemModifier;
import dev.aurelium.slate.function.ItemReplacer;
import dev.aurelium.slate.function.MenuListener;
import dev.aurelium.slate.function.PageProvider;
import dev.aurelium.slate.function.PropertyProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class MenuBuilder {
    private final Map<String, ItemBuilder> itemBuilders = new HashMap<String, ItemBuilder>();
    private final Map<String, TemplateBuilder<?>> templateBuilders = new HashMap();
    private final Map<String, ComponentBuilder<?>> componentBuilders = new HashMap();
    private final Map<String, ItemReplacer> titleReplacers = new HashMap<String, ItemReplacer>();
    private ItemReplacer titleAnyReplacer = p -> null;
    private PageProvider pageProvider = m -> 1;
    private PropertyProvider propertyProvider = m -> new HashMap();
    private ItemModifier fillItem = i -> null;
    private MenuListener openListener = m -> {};
    private MenuListener updateListener = m -> {};
    private Map<String, Object> defaultOptions = new HashMap<String, Object>();

    private MenuBuilder() {
    }

    public static MenuBuilder builder() {
        return new MenuBuilder();
    }

    public MenuBuilder item(String name, Consumer<ItemBuilder> item) {
        ItemBuilder builder = ItemBuilder.builder();
        item.accept(builder);
        this.itemBuilders.put(name, builder);
        return this;
    }

    public MenuBuilder item(String name, ItemBuilder builder) {
        this.itemBuilders.put(name, builder);
        return this;
    }

    public <T> MenuBuilder template(String name, Class<T> contextType, Consumer<TemplateBuilder<T>> template) {
        TemplateBuilder<T> builder = TemplateBuilder.builder(contextType);
        template.accept(builder);
        this.templateBuilders.put(name, builder);
        return this;
    }

    public <T> MenuBuilder template(String name, Class<T> contextType, TemplateBuilder<T> builder) {
        this.templateBuilders.put(name, builder);
        return this;
    }

    public <T> MenuBuilder component(String name, Class<T> contextType, Consumer<ComponentBuilder<T>> template) {
        ComponentBuilder<T> builder = ComponentBuilder.builder(contextType);
        template.accept(builder);
        this.componentBuilders.put(name, builder);
        return this;
    }

    public <T> MenuBuilder component(String name, Class<T> contextType, ComponentBuilder<T> builder) {
        this.componentBuilders.put(name, builder);
        return this;
    }

    public MenuBuilder replaceTitle(String from, ItemReplacer replacer) {
        this.titleReplacers.put(from, replacer);
        return this;
    }

    public MenuBuilder replaceTitleAny(ItemReplacer replacer) {
        this.titleAnyReplacer = replacer;
        return this;
    }

    public MenuBuilder pages(PageProvider provider) {
        this.pageProvider = provider;
        return this;
    }

    public MenuBuilder properties(PropertyProvider provider) {
        this.propertyProvider = provider;
        return this;
    }

    public MenuBuilder fillItem(ItemModifier modifier) {
        this.fillItem = modifier;
        return this;
    }

    public MenuBuilder onOpen(MenuListener listener) {
        this.openListener = listener;
        return this;
    }

    public MenuBuilder onUpdate(MenuListener listener) {
        this.updateListener = listener;
        return this;
    }

    public MenuBuilder defaultOptions(Map<String, Object> defaultOptions) {
        this.defaultOptions = defaultOptions;
        return this;
    }

    public BuiltMenu build() {
        HashMap<String, BuiltItem> items = new HashMap<String, BuiltItem>();
        for (Map.Entry<String, ItemBuilder> entry : this.itemBuilders.entrySet()) {
            items.put(entry.getKey(), entry.getValue().build());
        }
        HashMap templates = new HashMap();
        for (Map.Entry<String, TemplateBuilder<?>> entry : this.templateBuilders.entrySet()) {
            templates.put(entry.getKey(), entry.getValue().build());
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<String, ComponentBuilder<?>> entry : this.componentBuilders.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().build());
        }
        return new BuiltMenu(items, templates, hashMap, this.titleReplacers, this.titleAnyReplacer, this.pageProvider, this.propertyProvider, this.fillItem, this.openListener, this.updateListener, this.defaultOptions);
    }
}

