/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.slate.action;

import dev.aurelium.slate.Slate;
import dev.aurelium.slate.action.Action;
import dev.aurelium.slate.inv.content.InventoryContents;
import dev.aurelium.slate.menu.MenuInventory;
import dev.aurelium.slate.util.TextUtil;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandAction
extends Action {
    private final String command;
    private final Executor executor;

    public CommandAction(Slate slate, String command, Executor executor) {
        super(slate);
        this.command = command;
        this.executor = executor;
    }

    @Override
    public void execute(Player player, MenuInventory menuInventory, InventoryContents contents) {
        String formattedCommand = this.formatCommand(player, this.command);
        if (this.executor == Executor.CONSOLE) {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), formattedCommand);
        } else if (this.executor == Executor.PLAYER) {
            player.performCommand(formattedCommand);
        }
    }

    private String formatCommand(Player player, String command) {
        command = TextUtil.replace(command, "{player}", player.getName());
        command = PlaceholderAPI.setPlaceholders((Player)player, (String)command);
        return command;
    }

    public static enum Executor {
        CONSOLE,
        PLAYER;

    }
}

