/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.source;

import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.AuraSkillsBukkit;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.SourceType;
import java.util.Locale;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;

public class LevelerContext {
    private final AuraSkillsApi api;
    private final SourceType sourceType;

    public LevelerContext(AuraSkillsApi api, SourceType sourceType) {
        this.api = api;
        this.sourceType = sourceType;
    }

    public boolean disabled() {
        return !this.sourceType.isEnabled();
    }

    public boolean failsChecks(Cancellable event, Player player, Location location, Skill skill) {
        return this.isDisabled(skill) || this.isCancelled(event, skill) || this.blockLocation(player, location, skill) || this.blockPlayer(player, skill);
    }

    public boolean failsChecks(Player player, Location location, Skill skill) {
        return this.isDisabled(skill) || this.blockLocation(player, location, skill) || this.blockPlayer(player, skill);
    }

    public boolean isDisabled(Skill skill) {
        return !skill.isEnabled();
    }

    public boolean isCancelled(Cancellable event, Skill skill) {
        return skill.optionBoolean("check_cancelled", true) && event.isCancelled();
    }

    public boolean blockLocation(Player player, Location location, Skill skill) {
        return AuraSkillsBukkit.get().getLocationManager().isXpGainBlocked(location, player, skill);
    }

    public boolean blockPlayer(Player player, Skill skill) {
        if (!player.hasPermission("auraskills.skill." + skill.name().toLowerCase(Locale.ROOT))) {
            return true;
        }
        return this.api.getMainConfig().isDisabledInCreative() && player.getGameMode().equals((Object)GameMode.CREATIVE);
    }
}

