/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.ability;

import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.AuraSkillsBukkit;
import dev.aurelium.auraskills.api.ability.Ability;
import java.util.Locale;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class AbilityContext {
    private final AuraSkillsApi api;

    public AbilityContext(AuraSkillsApi api) {
        this.api = api;
    }

    public boolean isDisabled(Ability ability) {
        return !ability.isEnabled() || !ability.getSkill().isEnabled();
    }

    public boolean failsChecks(Player player, Ability ability) {
        if (!ability.isEnabled()) {
            return true;
        }
        if (this.api.getUser(player.getUniqueId()).getAbilityLevel(ability) <= 0) {
            return true;
        }
        if (AuraSkillsBukkit.get().getLocationManager().isPluginDisabled(player.getLocation(), player)) {
            return true;
        }
        if (!player.hasPermission("auraskills.skill." + ability.getSkill().name().toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (this.api.getMainConfig().isDisabledInCreative()) {
            return player.getGameMode().equals((Object)GameMode.CREATIVE);
        }
        return false;
    }
}

