/*
 * Decompiled with CFR 0.152.
 */
package dev.array21.bukkitreflectionlib;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.StringJoiner;

public class ReflectionUtil {
    public static String SERVER_VERSION;
    private static boolean useNewSpigotPackaging;
    private static int majorVersion;

    public static boolean isUseNewSpigotPackaging() {
        return useNewSpigotPackaging;
    }

    public static int getMajorVersion() {
        return majorVersion;
    }

    public static Class<?> getBukkitClass(String className) throws ClassNotFoundException {
        return Class.forName("org.bukkit.craftbukkit." + SERVER_VERSION + "." + className);
    }

    @Deprecated
    public static Class<?> getNmsClass(String className) throws ClassNotFoundException {
        return Class.forName("net.minecraft.server." + SERVER_VERSION + "." + className);
    }

    public static Class<?> getMinecraftClass(String className) throws ClassNotFoundException {
        return Class.forName("net.minecraft." + className);
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... args) throws NoSuchMethodException {
        Constructor<?> con = clazz.getConstructor(args);
        con.setAccessible(true);
        return con;
    }

    public static Enum<?> getEnum(Class<?> clazz, String constant) {
        Enum[] constants;
        for (Enum e : constants = (Enum[])clazz.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(constant)) continue;
            return e;
        }
        return null;
    }

    public static Enum<?> getEnum(Class<?> clazz, String enumname, String constant) throws ClassNotFoundException {
        Class<?> c = Class.forName(clazz.getName() + "$" + enumname);
        return ReflectionUtil.getEnum(c, constant);
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field f = clazz.getDeclaredField(fieldName);
        f.setAccessible(true);
        return f;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... args) throws NoSuchMethodException {
        Method m = clazz.getDeclaredMethod(methodName, args);
        m.setAccessible(true);
        return m;
    }

    public static Object invokeMethod(Object obj, String methodName) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return ReflectionUtil.invokeMethod(obj.getClass(), obj, methodName, new Object[0]);
    }

    public static Object invokeMethod(Object obj, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return ReflectionUtil.invokeMethod(obj.getClass(), obj, methodName, args);
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] argTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return ReflectionUtil.invokeMethod(obj.getClass(), obj, methodName, argTypes, args);
    }

    public static Object invokeMethod(Class<?> clazz, Object obj, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return ReflectionUtil.invokeMethod(clazz, obj, methodName, argTypes, args);
    }

    public static Object invokeMethod(Class<?> clazz, Object obj, String methodName, Class<?>[] argTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method m = ReflectionUtil.getMethod(clazz, methodName, argTypes);
        return m.invoke(obj, args);
    }

    public static Object getObject(Object obj, String name) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        return ReflectionUtil.getObject(obj.getClass(), obj, name);
    }

    @Deprecated
    public static Object getObject(Object obj, Class<?> clazz, String name) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        return ReflectionUtil.getObject(clazz, obj, name);
    }

    public static Object getObject(Class<?> clazz, Object obj, String name) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = ReflectionUtil.getField(clazz, name);
        f.setAccessible(true);
        return f.get(obj);
    }

    public static Object invokeConstructor(Class<?> clazz, Object ... args) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return ReflectionUtil.invokeConstructor(clazz, argTypes, args);
    }

    public static Object invokeConstructor(Class<?> clazz, Class<?>[] argTypes, Object[] args) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?> con = ReflectionUtil.getConstructor(clazz, argTypes);
        return con.newInstance(args);
    }

    public static void printMethodsInClass(Class<?> clazz) {
        System.out.println("Methods in " + clazz.getName() + ":");
        for (Method m : clazz.getDeclaredMethods()) {
            StringBuilder print = new StringBuilder(128);
            print.append(ReflectionUtil.getModifiers(m.getModifiers())).append(" ");
            print.append(m.getReturnType().getName()).append(" ");
            print.append(m.getName()).append("(");
            Class<?>[] parameterTypes = m.getParameterTypes();
            int parameterTypesLength = parameterTypes.length;
            for (int i = 0; i < parameterTypesLength; ++i) {
                print.append(parameterTypes[i].getName());
                if (i == parameterTypesLength - 1) continue;
                print.append(", ");
            }
            print.append(")");
            System.out.println(print.toString().strip());
        }
    }

    public static void printFieldsInClass(Class<?> clazz) {
        System.out.println("Fields in " + clazz.getName() + ":");
        for (Field f : clazz.getDeclaredFields()) {
            String print = ReflectionUtil.getModifiers(f.getModifiers()) + " " + f.getType().getName() + " " + f.getName();
            System.out.println(print.strip());
        }
    }

    private static String getModifiers(int modifiers) {
        StringJoiner modifiersStr = new StringJoiner(" ");
        if (Modifier.isPrivate(modifiers)) {
            modifiersStr.add("private");
        }
        if (Modifier.isProtected(modifiers)) {
            modifiersStr.add("protected");
        }
        if (Modifier.isPublic(modifiers)) {
            modifiersStr.add("public");
        }
        if (Modifier.isAbstract(modifiers)) {
            modifiersStr.add("abstract");
        }
        if (Modifier.isStatic(modifiers)) {
            modifiersStr.add("static");
        }
        if (Modifier.isFinal(modifiers)) {
            modifiersStr.add("static");
        }
        if (Modifier.isTransient(modifiers)) {
            modifiersStr.add("transient");
        }
        if (Modifier.isVolatile(modifiers)) {
            modifiersStr.add("volatile");
        }
        if (Modifier.isNative(modifiers)) {
            modifiersStr.add("native");
        }
        if (Modifier.isStrict(modifiers)) {
            modifiersStr.add("strictfp");
        }
        if (Modifier.isSynchronized(modifiers)) {
            modifiersStr.add("synchronized");
        }
        if (Modifier.isInterface(modifiers)) {
            modifiersStr.add("interface");
        }
        return modifiersStr.toString().strip();
    }

    static {
        try {
            Class<?> bukkitClass = Class.forName("org.bukkit.Bukkit");
            Object serverObject = ReflectionUtil.getMethod(bukkitClass, "getServer", new Class[0]).invoke(null, new Object[0]);
            String serverPackageName = serverObject.getClass().getPackage().getName();
            SERVER_VERSION = serverPackageName.substring(serverPackageName.lastIndexOf(46) + 1);
            String major = SERVER_VERSION.split("_")[1];
            majorVersion = Integer.parseInt(major);
            useNewSpigotPackaging = majorVersion >= 17;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

