/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.DefaultYoutubeTrackDetails;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetails;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetailsLoader;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackJsonData;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultYoutubeTrackDetailsLoader
implements YoutubeTrackDetailsLoader {
    private static final Logger log = LoggerFactory.getLogger(DefaultYoutubeTrackDetailsLoader.class);
    private volatile CachedPlayerScript cachedPlayerScript = null;

    @Override
    public YoutubeTrackDetails loadDetails(HttpInterface httpInterface, String videoId, boolean requireFormats, YoutubeAudioSourceManager sourceManager) {
        try {
            return this.load(httpInterface, videoId, requireFormats, sourceManager);
        }
        catch (IOException e) {
            throw ExceptionTools.toRuntimeException(e);
        }
    }

    private YoutubeTrackDetails load(HttpInterface httpInterface, String videoId, boolean requireFormats, YoutubeAudioSourceManager sourceManager) throws IOException {
        JsonBrowser mainInfo = this.loadTrackInfoFromInnertube(httpInterface, videoId, sourceManager, null);
        try {
            YoutubeTrackJsonData initialData = this.loadBaseResponse(mainInfo, httpInterface, videoId, sourceManager);
            if (initialData == null) {
                return null;
            }
            if (!videoId.equals(initialData.playerResponse.get("videoDetails").get("videoId").text())) {
                throw new FriendlyException("Video returned by YouTube isn't what was requested", FriendlyException.Severity.COMMON, new IllegalStateException(initialData.playerResponse.format()));
            }
            YoutubeTrackJsonData finalData = this.augmentWithPlayerScript(initialData, httpInterface, videoId, requireFormats);
            return new DefaultYoutubeTrackDetails(videoId, finalData);
        }
        catch (FriendlyException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionTools.throwWithDebugInfo(log, e, "Error when extracting data", "mainJson", mainInfo.format());
        }
    }

    protected YoutubeTrackJsonData loadBaseResponse(JsonBrowser mainInfo, HttpInterface httpInterface, String videoId, YoutubeAudioSourceManager sourceManager) throws IOException {
        JsonBrowser trackInfo;
        YoutubeTrackJsonData data = YoutubeTrackJsonData.fromMainResult(mainInfo);
        InfoStatus status = this.checkPlayabilityStatus(data.playerResponse, false);
        if (status == InfoStatus.DOES_NOT_EXIST) {
            return null;
        }
        if (status == InfoStatus.PREMIERE_TRAILER) {
            trackInfo = this.loadTrackInfoFromInnertube(httpInterface, videoId, sourceManager, status);
            data = YoutubeTrackJsonData.fromMainResult(trackInfo.get("playabilityStatus").get("errorScreen").get("ypcTrailerRenderer").get("unserializedPlayerResponse"));
            status = this.checkPlayabilityStatus(data.playerResponse, true);
        }
        if (status == InfoStatus.REQUIRES_LOGIN) {
            trackInfo = this.loadTrackInfoFromInnertube(httpInterface, videoId, sourceManager, status);
            data = YoutubeTrackJsonData.fromMainResult(trackInfo);
            status = this.checkPlayabilityStatus(data.playerResponse, true);
        }
        if (status == InfoStatus.NON_EMBEDDABLE) {
            trackInfo = this.loadTrackInfoFromInnertube(httpInterface, videoId, sourceManager, status);
            data = YoutubeTrackJsonData.fromMainResult(trackInfo);
            this.checkPlayabilityStatus(data.playerResponse, true);
        }
        return data;
    }

    protected InfoStatus checkPlayabilityStatus(JsonBrowser playerResponse, boolean secondCheck) {
        JsonBrowser statusBlock = playerResponse.get("playabilityStatus");
        if (statusBlock.isNull()) {
            throw new RuntimeException("No playability status block.");
        }
        String status = statusBlock.get("status").text();
        if (status == null) {
            throw new RuntimeException("No playability status field.");
        }
        if ("OK".equals(status)) {
            return InfoStatus.INFO_PRESENT;
        }
        if ("ERROR".equals(status)) {
            String errorReason = statusBlock.get("reason").text();
            if (errorReason.contains("This video is unavailable")) {
                return InfoStatus.DOES_NOT_EXIST;
            }
            throw new FriendlyException(errorReason, FriendlyException.Severity.COMMON, null);
        }
        if ("UNPLAYABLE".equals(status)) {
            String unplayableReason = this.getUnplayableReason(statusBlock);
            if (unplayableReason.contains("Playback on other websites has been disabled by the video owner")) {
                return InfoStatus.NON_EMBEDDABLE;
            }
            throw new FriendlyException(unplayableReason, FriendlyException.Severity.COMMON, null);
        }
        if ("LOGIN_REQUIRED".equals(status)) {
            String loginReason = statusBlock.get("reason").text();
            if (loginReason.contains("This video is private")) {
                throw new FriendlyException("This is a private video.", FriendlyException.Severity.COMMON, null);
            }
            if (loginReason.contains("This video may be inappropriate for some users") && secondCheck) {
                throw new FriendlyException("This video requires age verification.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("You did not set email and password in YoutubeAudioSourceManager."));
            }
            return InfoStatus.REQUIRES_LOGIN;
        }
        if ("CONTENT_CHECK_REQUIRED".equals(status)) {
            throw new FriendlyException(this.getUnplayableReason(statusBlock), FriendlyException.Severity.COMMON, null);
        }
        if ("LIVE_STREAM_OFFLINE".equals(status)) {
            if (!statusBlock.get("errorScreen").get("ypcTrailerRenderer").isNull()) {
                return InfoStatus.PREMIERE_TRAILER;
            }
            throw new FriendlyException(this.getUnplayableReason(statusBlock), FriendlyException.Severity.COMMON, null);
        }
        throw new FriendlyException("This video cannot be viewed anonymously.", FriendlyException.Severity.COMMON, null);
    }

    protected String getUnplayableReason(JsonBrowser statusBlock) {
        JsonBrowser playerErrorMessage = statusBlock.get("errorScreen").get("playerErrorMessageRenderer");
        String unplayableReason = statusBlock.get("reason").text();
        if (!playerErrorMessage.get("subreason").isNull()) {
            JsonBrowser subreason = playerErrorMessage.get("subreason");
            if (!subreason.get("simpleText").isNull()) {
                unplayableReason = subreason.get("simpleText").text();
            } else if (!subreason.get("runs").isNull() && subreason.get("runs").isList()) {
                StringBuilder reasonBuilder = new StringBuilder();
                subreason.get("runs").values().forEach(item -> reasonBuilder.append(item.get("text").text()).append('\n'));
                unplayableReason = reasonBuilder.toString();
            }
        }
        return unplayableReason;
    }

    /*
     * Exception decompiling
     */
    protected JsonBrowser loadTrackInfoFromInnertube(HttpInterface httpInterface, String videoId, YoutubeAudioSourceManager sourceManager, InfoStatus infoStatus) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected YoutubeTrackJsonData augmentWithPlayerScript(YoutubeTrackJsonData data, HttpInterface httpInterface, String videoId, boolean requireFormats) throws IOException {
        long now = System.currentTimeMillis();
        if (data.playerScriptUrl != null) {
            this.cachedPlayerScript = new CachedPlayerScript(data.playerScriptUrl, now);
            return data;
        }
        if (!requireFormats) {
            return data;
        }
        CachedPlayerScript cached = this.cachedPlayerScript;
        if (cached != null && cached.timestamp + 600000L >= now) {
            return data.withPlayerScriptUrl(cached.playerScriptUrl);
        }
        return data.withPlayerScriptUrl(this.fetchScript(videoId, httpInterface));
    }

    private String fetchScript(String videoId, HttpInterface httpInterface) throws IOException {
        long now = System.currentTimeMillis();
        try (CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)new HttpGet("https://www.youtube.com/embed/" + videoId));){
            HttpClientTools.assertSuccessWithContent((HttpResponse)response, "youtube embed video id");
            String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
            String encodedUrl = DataFormatTools.extractBetween(responseText, "\"jsUrl\":\"", "\"");
            if (encodedUrl == null) {
                throw ExceptionTools.throwWithDebugInfo(log, null, "no jsUrl found", "html", responseText);
            }
            String fetchedPlayerScript = JsonBrowser.parse("{\"url\":\"" + encodedUrl + "\"}").get("url").text();
            this.cachedPlayerScript = new CachedPlayerScript(fetchedPlayerScript, now);
            String string = fetchedPlayerScript;
            return string;
        }
    }

    protected static class CachedPlayerScript {
        public final String playerScriptUrl;
        public final long timestamp;

        public CachedPlayerScript(String playerScriptUrl, long timestamp) {
            this.playerScriptUrl = playerScriptUrl;
            this.timestamp = timestamp;
        }
    }

    protected static enum InfoStatus {
        INFO_PRESENT,
        REQUIRES_LOGIN,
        DOES_NOT_EXIST,
        CONTENT_CHECK_REQUIRED,
        LIVE_STREAM_OFFLINE,
        PREMIERE_TRAILER,
        NON_EMBEDDABLE;

    }
}

