/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.yamusic;

import com.sedmelluq.discord.lavaplayer.source.yamusic.DefaultYandexMusicTrackLoader;
import com.sedmelluq.discord.lavaplayer.source.yamusic.YandexMusicPlaylistLoader;
import com.sedmelluq.discord.lavaplayer.source.yamusic.YandexMusicUtils;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.FutureTools;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;

public class DefaultYandexMusicPlaylistLoader
extends DefaultYandexMusicTrackLoader
implements YandexMusicPlaylistLoader {
    private static final String PLAYLIST_INFO_FORMAT = "https://api.music.yandex.net/users/%s/playlists/%s";
    private static final String ALBUM_INFO_FORMAT = "https://api.music.yandex.net/albums/%s/with-tracks";
    private static final String ARTIST_INFO_FORMAT = "https://api.music.yandex.net/artists/%s/brief-info";
    private final ExecutorService tracksLoader = Executors.newCachedThreadPool();

    @Override
    public AudioItem loadPlaylist(String login, String id, String trackProperty, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        return this.loadPlaylistUrl(String.format(PLAYLIST_INFO_FORMAT, login, id), trackProperty, trackFactory);
    }

    @Override
    public AudioItem loadPlaylist(String id, String trackProperty, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        if (trackProperty.equals("volumes")) {
            return this.loadPlaylistUrl(String.format(ALBUM_INFO_FORMAT, id), trackProperty, trackFactory);
        }
        return this.loadPlaylistUrl(String.format(ARTIST_INFO_FORMAT, id), trackProperty, trackFactory);
    }

    private AudioItem loadPlaylistUrl(String url, String trackProperty, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        return this.extractFromApi(url, (httpClient, result) -> {
            if (DefaultYandexMusicPlaylistLoader.hasError(result)) {
                return AudioReference.NO_TRACK;
            }
            JsonBrowser volumes = result.get(trackProperty);
            if (volumes.isNull()) {
                throw new FriendlyException("Volumes is empty", FriendlyException.Severity.SUSPICIOUS, null);
            }
            ArrayList<Future<AudioTrack>> futures = new ArrayList<Future<AudioTrack>>();
            ExecutorCompletionService<AudioTrack> completionService = new ExecutorCompletionService<AudioTrack>(this.tracksLoader);
            for (JsonBrowser trackInfo : volumes.values()) {
                if (trackInfo.isList()) {
                    for (JsonBrowser innerInfo : trackInfo.values()) {
                        futures.add(completionService.submit(() -> this.loadTrack(innerInfo, trackFactory)));
                    }
                    continue;
                }
                futures.add(completionService.submit(() -> this.loadTrack(trackInfo, trackFactory)));
            }
            if (futures.isEmpty()) {
                return AudioReference.NO_TRACK;
            }
            List<AudioTrack> tracks = FutureTools.awaitList(completionService, futures);
            if (futures.isEmpty()) {
                return AudioReference.NO_TRACK;
            }
            String name = trackProperty.equals("volumes") || trackProperty.equals("tracks") ? result.get("title").text() : result.get("artist").get("name").text();
            return new BasicAudioPlaylist(name, tracks, null, false);
        });
    }

    static boolean hasError(JsonBrowser result) {
        JsonBrowser error = result.get("error");
        if (!error.isNull()) {
            String code = error.text();
            if ("not-found".equals(code)) {
                return true;
            }
            throw new FriendlyException(String.format("Yandex Music returned an error code: %s", code), FriendlyException.Severity.SUSPICIOUS, null);
        }
        return false;
    }

    private AudioTrack loadTrack(JsonBrowser trackInfo, Function<AudioTrackInfo, AudioTrack> trackFactory) {
        if (!trackInfo.get("title").isNull()) {
            return YandexMusicUtils.extractTrack(trackInfo, trackFactory);
        }
        if (!trackInfo.get("track").isNull()) {
            return YandexMusicUtils.extractTrack(trackInfo, trackFactory);
        }
        String trackId = trackInfo.get("id").text();
        String albumId = trackInfo.get("albumId").text();
        if (trackId == null || albumId == null) {
            throw new FriendlyException("Could not load playlist track", FriendlyException.Severity.COMMON, null);
        }
        return (AudioTrack)this.loadTrack(albumId, trackId, trackFactory);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.tracksLoader.shutdown();
    }
}

