/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.twitch;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class TwitchStreamAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final String STREAM_NAME_REGEX = "^https://(?:www\\.|go\\.|m\\.)?twitch.tv/([^/]+)$";
    private static final Pattern streamNameRegex = Pattern.compile("^https://(?:www\\.|go\\.|m\\.)?twitch.tv/([^/]+)$");
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    private String twitchClientId;
    private String twitchDeviceId;

    public TwitchStreamAudioSourceManager() {
        this.initRequestHeaders();
    }

    public String getClientId() {
        return this.twitchClientId;
    }

    public String getDeviceId() {
        return this.twitchDeviceId;
    }

    @Override
    public String getSourceName() {
        return "twitch";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String streamName = TwitchStreamAudioSourceManager.getChannelIdentifierFromUrl(reference.identifier);
        if (streamName == null) {
            return null;
        }
        JsonBrowser channelInfo = this.fetchStreamChannelInfo(streamName).get("data").get("user");
        if (channelInfo == null || channelInfo.get("stream").get("type").isNull()) {
            return AudioReference.NO_TRACK;
        }
        String title = channelInfo.get("lastBroadcast").get("title").text();
        String thumbnail = String.format("https://static-cdn.jtvnw.net/previews-ttv/live_user_%s-440x248.jpg", streamName);
        return new TwitchStreamAudioTrack(new AudioTrackInfo(title, streamName, Long.MAX_VALUE, reference.identifier, true, reference.identifier, thumbnail, null), this);
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new TwitchStreamAudioTrack(trackInfo, this);
    }

    public static String getChannelIdentifierFromUrl(String url) {
        Matcher matcher = streamNameRegex.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1).toLowerCase(Locale.ROOT);
    }

    public HttpUriRequest createGetRequest(String url) {
        return TwitchStreamAudioSourceManager.addClientHeaders((HttpUriRequest)new HttpGet(url), this.twitchClientId, this.twitchDeviceId);
    }

    public HttpUriRequest createGetRequest(URI url) {
        return TwitchStreamAudioSourceManager.addClientHeaders((HttpUriRequest)new HttpGet(url), this.twitchClientId, this.twitchDeviceId);
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    private static HttpUriRequest addClientHeaders(HttpUriRequest request, String clientId, String deviceId) {
        request.setHeader("Client-ID", clientId);
        request.setHeader("X-Device-ID", deviceId);
        return request;
    }

    protected JsonBrowser fetchAccessToken(String name) {
        JsonBrowser jsonBrowser;
        block8: {
            HttpInterface httpInterface = this.getHttpInterface();
            try {
                HttpPost post = new HttpPost("https://gql.twitch.tv/gql");
                TwitchStreamAudioSourceManager.addClientHeaders((HttpUriRequest)post, this.twitchClientId, this.twitchDeviceId);
                post.setEntity((HttpEntity)new StringEntity(String.format("{\"operationName\":\"PlaybackAccessToken_Template\",\"query\":\"query PlaybackAccessToken_Template($login: String!,$isLive:Boolean!,$vodID:ID!,$isVod:Boolean!,$playerType:String!){streamPlaybackAccessToken(channelName:$login,params:{platform:\\\"web\\\",playerBackend:\\\"mediaplayer\\\",playerType:$playerType})@include(if:$isLive){value signature __typename}videoPlaybackAccessToken(id:$vodID,params:{platform:\\\"web\\\",playerBackend:\\\"mediaplayer\\\",playerType:$playerType})@include(if:$isVod){value signature __typename}}\",\"variables\":{\"isLive\":true,\"login\":\"%s\",\"isVod\":false,\"vodID\":\"\",\"playerType\":\"site\"}}", name)));
                jsonBrowser = HttpClientTools.fetchResponseAsJson(httpInterface, (HttpUriRequest)post);
                if (httpInterface == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpInterface != null) {
                        try {
                            httpInterface.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FriendlyException("Loading Twitch channel access token failed.", FriendlyException.Severity.SUSPICIOUS, e);
                }
            }
            httpInterface.close();
        }
        return jsonBrowser;
    }

    private JsonBrowser fetchStreamChannelInfo(String channelId) {
        JsonBrowser jsonBrowser;
        block8: {
            HttpInterface httpInterface = this.getHttpInterface();
            try {
                HttpPost post = new HttpPost("https://gql.twitch.tv/gql");
                TwitchStreamAudioSourceManager.addClientHeaders((HttpUriRequest)post, this.twitchClientId, this.twitchDeviceId);
                post.setEntity((HttpEntity)new StringEntity(String.format("{\"operationName\":\"StreamMetadata\",\"variables\":{\"channelLogin\":\"%s\"},\"extensions\":{\"persistedQuery\":{\"version\":1,\"sha256Hash\":\"1c719a40e481453e5c48d9bb585d971b8b372f8ebb105b17076722264dfa5b3e\"}}}", channelId)));
                jsonBrowser = HttpClientTools.fetchResponseAsJson(httpInterface, (HttpUriRequest)post);
                if (httpInterface == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpInterface != null) {
                        try {
                            httpInterface.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FriendlyException("Loading Twitch channel information failed.", FriendlyException.Severity.SUSPICIOUS, e);
                }
            }
            httpInterface.close();
        }
        return jsonBrowser;
    }

    private void initRequestHeaders() {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            HttpGet get = new HttpGet("https://www.twitch.tv");
            get.setHeader("Accept", "text/html");
            CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)get);
            HttpClientTools.assertSuccessWithContent((HttpResponse)response, "twitch main page");
            String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
            this.twitchClientId = DataFormatTools.extractBetween(responseText, "clientId=\"", "\"");
            for (Header header : response.getAllHeaders()) {
                if (!header.getName().contains("Set-Cookie") || !header.getValue().contains("unique_id=")) continue;
                this.twitchDeviceId = DataFormatTools.extractBetween(header.toString(), "unique_id=", ";");
            }
        }
        catch (IOException e) {
            throw new FriendlyException("Loading Twitch main page failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    @Override
    public void shutdown() {
        ExceptionTools.closeWithWarnings(this.httpInterfaceManager);
    }
}

