/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.stream;

import com.sedmelluq.discord.lavaplayer.container.playlists.ExtendedM3uParser;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public abstract class M3uStreamSegmentUrlProvider {
    private static final long SEGMENT_WAIT_STEP_MS = 200L;
    private static final RequestConfig streamingRequestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectionRequestTimeout(5000).setConnectTimeout(5000).build();
    protected String baseUrl;
    protected SegmentInfo lastSegment;

    protected M3uStreamSegmentUrlProvider() {
        this(null);
    }

    protected M3uStreamSegmentUrlProvider(String originUrl) {
        if (originUrl != null) {
            if (originUrl.endsWith("/")) {
                originUrl = originUrl.substring(0, originUrl.length() - 1);
            }
            this.baseUrl = originUrl.substring(0, originUrl.lastIndexOf("/"));
        } else {
            this.baseUrl = null;
        }
    }

    protected static String createSegmentUrl(String playlistUrl, String segmentName) {
        return URI.create(playlistUrl).resolve(segmentName).toString();
    }

    protected abstract String getQualityFromM3uDirective(ExtendedM3uParser.Line var1);

    protected abstract String fetchSegmentPlaylistUrl(HttpInterface var1) throws IOException;

    protected String getNextSegmentUrl(HttpInterface httpInterface) {
        try {
            List<SegmentInfo> segments;
            SegmentInfo nextSegment;
            String streamSegmentPlaylistUrl = this.fetchSegmentPlaylistUrl(httpInterface);
            if (streamSegmentPlaylistUrl == null) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            while ((nextSegment = this.chooseNextSegment(segments = this.loadStreamSegmentsList(httpInterface, streamSegmentPlaylistUrl), this.lastSegment)) == null && this.shouldWaitForSegment(startTime, segments)) {
                Thread.sleep(200L);
            }
            if (nextSegment == null) {
                return null;
            }
            this.lastSegment = nextSegment;
            return M3uStreamSegmentUrlProvider.createSegmentUrl(streamSegmentPlaylistUrl, this.lastSegment.url);
        }
        catch (IOException e) {
            throw new FriendlyException("Failed to get next part of the stream.", FriendlyException.Severity.SUSPICIOUS, e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getNextSegmentStream(HttpInterface httpInterface) {
        httpInterface.getContext().setRequestConfig(streamingRequestConfig);
        String url = this.getNextSegmentUrl(httpInterface);
        if (url == null) {
            return null;
        }
        CloseableHttpResponse response = null;
        boolean success = false;
        try {
            response = httpInterface.execute(this.createSegmentGetRequest(url));
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new IOException("Invalid status code from segment data URL: " + statusCode);
            }
            success = true;
            InputStream inputStream = response.getEntity().getContent();
            return inputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (response != null && !success) {
                ExceptionTools.closeWithWarnings((AutoCloseable)response);
            }
        }
    }

    protected abstract HttpUriRequest createSegmentGetRequest(String var1);

    protected boolean isAbsoluteUrl(String url) {
        try {
            return this.baseUrl == null || new URI(url).isAbsolute();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    protected String getAbsoluteUrl(String url) {
        return this.baseUrl + (url.startsWith("/") ? url : "/" + url);
    }

    protected List<ChannelStreamInfo> loadChannelStreamsList(String[] lines) {
        ExtendedM3uParser.Line streamInfoLine = null;
        ArrayList<ChannelStreamInfo> streams = new ArrayList<ChannelStreamInfo>();
        for (String lineText : lines) {
            ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(lineText);
            if (line.isData() && streamInfoLine != null) {
                String quality = this.getQualityFromM3uDirective(streamInfoLine);
                if (quality != null) {
                    String lineData = line.lineData;
                    streams.add(new ChannelStreamInfo(quality, this.isAbsoluteUrl(lineData) ? lineData : this.getAbsoluteUrl(lineData)));
                }
                streamInfoLine = null;
                continue;
            }
            if (!line.isDirective() || !"EXT-X-STREAM-INF".equals(line.directiveName)) continue;
            streamInfoLine = line;
        }
        return streams;
    }

    protected List<SegmentInfo> loadStreamSegmentsList(HttpInterface httpInterface, String streamSegmentPlaylistUrl) throws IOException {
        ArrayList<SegmentInfo> segments = new ArrayList<SegmentInfo>();
        ExtendedM3uParser.Line segmentInfo = null;
        for (String lineText : HttpClientTools.fetchResponseLines(httpInterface, (HttpUriRequest)new HttpGet(streamSegmentPlaylistUrl), "stream segments list")) {
            ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(lineText);
            if (line.isDirective() && "EXTINF".equals(line.directiveName)) {
                segmentInfo = line;
            }
            if (!line.isData()) continue;
            if (segmentInfo != null && segmentInfo.extraData.contains(",")) {
                String[] fields = segmentInfo.extraData.split(",", 2);
                segments.add(new SegmentInfo(line.lineData, M3uStreamSegmentUrlProvider.parseSecondDuration(fields[0]), fields[1]));
                continue;
            }
            segments.add(new SegmentInfo(line.lineData, null, null));
        }
        return segments;
    }

    private static Long parseSecondDuration(String value) {
        try {
            double asDouble = Double.parseDouble(value);
            return (long)(asDouble * 1000.0);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    protected SegmentInfo chooseNextSegment(List<SegmentInfo> segments, SegmentInfo lastSegment) {
        SegmentInfo selected = null;
        for (int i = segments.size() - 1; i >= 0; --i) {
            SegmentInfo current = segments.get(i);
            if (lastSegment != null && current.url.equals(lastSegment.url)) break;
            selected = current;
        }
        return selected;
    }

    private boolean shouldWaitForSegment(long startTime, List<SegmentInfo> segments) {
        if (!segments.isEmpty()) {
            SegmentInfo sampleSegment = segments.get(0);
            if (sampleSegment.duration != null) {
                return System.currentTimeMillis() - startTime < sampleSegment.duration;
            }
        }
        return false;
    }

    protected static class SegmentInfo {
        public final String url;
        public final Long duration;
        public final String name;

        public SegmentInfo(String url, Long duration, String name) {
            this.url = url;
            this.duration = duration;
            this.name = name;
        }
    }

    protected static class ChannelStreamInfo {
        public final String quality;
        public final String url;

        private ChannelStreamInfo(String quality, String url) {
            this.quality = quality;
            this.url = url;
        }
    }
}

