/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.soundcloud;

import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudDataLoader;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;

public class DefaultSoundCloudDataLoader
implements SoundCloudDataLoader {
    @Override
    public JsonBrowser load(HttpInterface httpInterface, String url) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)new HttpGet(this.buildUri(url)));){
            if (response.getStatusLine().getStatusCode() == 404) {
                JsonBrowser jsonBrowser = JsonBrowser.NULL_BROWSER;
                return jsonBrowser;
            }
            HttpClientTools.assertSuccessWithContent((HttpResponse)response, "video page response");
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            JsonBrowser jsonBrowser = JsonBrowser.parse(json);
            return jsonBrowser;
        }
    }

    private URI buildUri(String url) {
        try {
            return new URIBuilder("https://api-v2.soundcloud.com/resolve").addParameter("url", url).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

